/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.auth.req;

import com.yeepay.yop.sdk.auth.SignOptions;
import com.yeepay.yop.sdk.security.DigestAlgEnum;
import com.yeepay.yop.sdk.security.SignerTypeEnum;

public class AuthorizationReq {
    private final SignerTypeEnum signerType;
    private final String credentialType;
    private final String signatureAlg;
    private final DigestAlgEnum digestAlg;
    private final String protocolPrefix;

    private AuthorizationReq(SignerTypeEnum signerType, String credentialType, String signatureAlg, DigestAlgEnum digestAlg, String protocolPrefix) {
        this.signerType = signerType;
        this.credentialType = credentialType;
        this.signatureAlg = signatureAlg;
        this.digestAlg = digestAlg;
        this.protocolPrefix = protocolPrefix;
    }

    public SignerTypeEnum getSignerType() {
        return this.signerType;
    }

    public String getCredentialType() {
        return this.credentialType;
    }

    public String getSignatureAlg() {
        return this.signatureAlg;
    }

    public DigestAlgEnum getDigestAlg() {
        return this.digestAlg;
    }

    public String getProtocolPrefix() {
        return this.protocolPrefix;
    }

    public SignOptions getSignOptions() {
        return new SignOptions().withDigestAlg(this.digestAlg).withProtocolPrefix(this.protocolPrefix);
    }

    public static final class Builder {
        private SignerTypeEnum signerType;
        private String credentialType;
        private String signatureAlg;
        private DigestAlgEnum digestAlg;
        private String protocolPrefix;

        private Builder() {
        }

        public static Builder anAuthorizationReq() {
            return new Builder();
        }

        public Builder withSignerType(SignerTypeEnum signerType) {
            this.signerType = signerType;
            return this;
        }

        public Builder withCredentialType(String credentialType) {
            this.credentialType = credentialType;
            return this;
        }

        public Builder withSignatureAlg(String signatureAlg) {
            this.signatureAlg = signatureAlg;
            return this;
        }

        public Builder withDigestAlg(DigestAlgEnum digestAlg) {
            this.digestAlg = digestAlg;
            return this;
        }

        public Builder withProtocolPrefix(String protocolPrefix) {
            this.protocolPrefix = protocolPrefix;
            return this;
        }

        public AuthorizationReq build() {
            return new AuthorizationReq(this.signerType, this.credentialType, this.signatureAlg, this.digestAlg, this.protocolPrefix);
        }
    }
}

