/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.auth.credentials.provider.loader;

import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentialsHolder;
import com.yeepay.yop.sdk.auth.credentials.provider.EncryptCertificate;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProvider;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProviderRegistry;
import com.yeepay.yop.sdk.auth.credentials.provider.loader.YopPlatformCredentialsLoader;
import com.yeepay.yop.sdk.config.provider.YopSdkConfigProviderRegistry;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.config.provider.file.YopCertStore;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.service.common.YopClient;
import com.yeepay.yop.sdk.service.common.YopClientBuilder;
import com.yeepay.yop.sdk.service.common.request.YopRequest;
import com.yeepay.yop.sdk.service.common.response.YopResponse;
import com.yeepay.yop.sdk.utils.Encodes;
import com.yeepay.yop.sdk.utils.Sm2CertUtils;
import com.yeepay.yop.sdk.utils.Sm4Utils;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopSmPlatformCredentialsRemoteLoader
implements YopPlatformCredentialsLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopSmPlatformCredentialsRemoteLoader.class);
    private static final String CERT_DOWNLOAD_API_URI = "/rest/v1.0/yop/platform/certs";
    private static final String CERT_DOWNLOAD_API_METHOD = "GET";
    private static final String CERT_DOWNLOAD_API_SECURITY = "YOP-SM2-SM3";

    @Override
    public Map<String, YopPlatformCredentials> load(String appKey, String serialNo) {
        YopCredentialsProvider yopCredentialsProvider = YopCredentialsProviderRegistry.getProvider();
        YopCredentials yopCredentials = yopCredentialsProvider.getCredentials(appKey, "SM2");
        Map<String, X509Certificate> x509CertificateMap = this.loadAndVerifyFromRemote(yopCredentials, serialNo, yopCredentialsProvider.getIsvEncryptKey(yopCredentials.getAppKey()));
        return this.storeCerts(YopSdkConfigProviderRegistry.getProvider().getConfig().getYopCertStore(), x509CertificateMap);
    }

    private Map<String, YopPlatformCredentials> storeCerts(YopCertStore yopCertStore, Map<String, X509Certificate> plainCerts) {
        LinkedHashMap<String, YopPlatformCredentials> result = new LinkedHashMap<String, YopPlatformCredentials>();
        if (null == plainCerts || 0 == plainCerts.size()) {
            return null;
        }
        for (Map.Entry<String, X509Certificate> certificateEntry : plainCerts.entrySet()) {
            try {
                result.put(certificateEntry.getKey(), new YopPlatformCredentialsHolder().withSerialNo(certificateEntry.getKey()).withPublicKey(CertTypeEnum.SM2, certificateEntry.getValue().getPublicKey()));
                if (!yopCertStore.getEnable().booleanValue()) continue;
                File certStoreDir = new File(yopCertStore.getPath());
                if (!certStoreDir.exists()) {
                    certStoreDir.mkdirs();
                }
                File certFile = new File(certStoreDir, "yop_platform_sm_cert_" + certificateEntry.getKey() + ".cer");
                JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)new FileWriter(certFile));
                Throwable throwable = null;
                try {
                    jcaPEMWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", certificateEntry.getValue().getEncoded()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jcaPEMWriter == null) continue;
                    if (throwable != null) {
                        try {
                            jcaPEMWriter.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jcaPEMWriter.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("error when store yop cert, ex:", (Throwable)e);
            }
        }
        return result;
    }

    private synchronized Map<String, X509Certificate> loadAndVerifyFromRemote(YopCredentials yopCredentials, String serialNo, List<YopCertConfig> isvEncryptKeys) {
        try {
            YopClient yopClient = (YopClient)YopClientBuilder.builder().build();
            YopRequest request = new YopRequest(CERT_DOWNLOAD_API_URI, CERT_DOWNLOAD_API_METHOD);
            request.getRequestConfig().setSkipVerifySign(true);
            request.getRequestConfig().setSecurityReq(CERT_DOWNLOAD_API_SECURITY);
            request.getRequestConfig().setCredentials(yopCredentials);
            if (StringUtils.isNotBlank((CharSequence)serialNo)) {
                request.addParameter("serialNo", serialNo);
            }
            YopResponse response = yopClient.request(request);
            List<EncryptCertificate> encryptCerts = this.parseYopResponse(response);
            return this.decryptCerts(encryptCerts, isvEncryptKeys);
        }
        catch (Exception e) {
            LOGGER.error("error when load sm2 cert from remote, ex:", (Throwable)e);
            return null;
        }
    }

    private Map<String, X509Certificate> decryptCerts(List<EncryptCertificate> encryptCerts, List<YopCertConfig> isvEncryptKeys) {
        if (CollectionUtils.isNotEmpty(encryptCerts)) {
            HashMap certMap = Maps.newHashMapWithExpectedSize((int)encryptCerts.size());
            for (EncryptCertificate encryptCert : encryptCerts) {
                X509Certificate decryptCert = this.decryptCert(encryptCert, isvEncryptKeys);
                if (null == decryptCert) continue;
                certMap.put(decryptCert.getSerialNumber().toString(), decryptCert);
            }
            return certMap;
        }
        return null;
    }

    private X509Certificate decryptCert(EncryptCertificate encryptCert, List<YopCertConfig> isvEncryptKeys) {
        for (YopCertConfig isvEncryptKey : isvEncryptKeys) {
            if (isvEncryptKey.getCertType() == CertTypeEnum.SM4) {
                byte[] certBytes = null;
                String certKeyBase64 = isvEncryptKey.getValue();
                try {
                    certBytes = Sm4Utils.decrypt_GCM_NoPadding(Encodes.decodeBase64(certKeyBase64), encryptCert.getAssociatedData(), encryptCert.getNonce(), encryptCert.getCiphertext());
                }
                catch (Exception e) {
                    LOGGER.warn("fail to try decrypt cert, certKey:" + certKeyBase64 + ", cert:" + encryptCert + ", ex:", (Throwable)e);
                }
                if (null == certBytes) continue;
                try {
                    return Sm2CertUtils.getX509Certificate(certBytes);
                }
                catch (Exception e) {
                    LOGGER.error("error to parse cert bytes, certKey:" + certKeyBase64 + ", cert:" + encryptCert + ", ex:", (Throwable)e);
                    continue;
                }
            }
            LOGGER.warn("no available sm4 isv_encrypt_key found!");
        }
        return null;
    }

    private List<EncryptCertificate> parseYopResponse(YopResponse response) {
        List data;
        ArrayList<EncryptCertificate> encryptCerts = new ArrayList<EncryptCertificate>();
        Map result = (Map)response.getResult();
        if (MapUtils.isNotEmpty((Map)result) && CollectionUtils.isNotEmpty((Collection)(data = (List)result.get("data")))) {
            for (Map map : data) {
                Map encryptCertificate = (Map)map.get("encryptCertificate");
                if (null == encryptCertificate) continue;
                String algorithm = (String)encryptCertificate.get("algorithm");
                String nonce = (String)encryptCertificate.get("nonce");
                String associatedData = (String)encryptCertificate.get("associatedData");
                String cipherText = (String)encryptCertificate.get("cipherText");
                encryptCerts.add(new EncryptCertificate(algorithm, nonce, associatedData, cipherText));
            }
        }
        return encryptCerts;
    }
}

