/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.auth.credentials.provider.loader;

import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentialsHolder;
import com.yeepay.yop.sdk.auth.credentials.provider.loader.YopPlatformCredentialsLoader;
import com.yeepay.yop.sdk.auth.credentials.provider.loader.YopSmPlatformCredentialsRemoteLoader;
import com.yeepay.yop.sdk.config.provider.YopSdkConfigProviderRegistry;
import com.yeepay.yop.sdk.config.provider.file.YopCertStore;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.utils.EnvUtils;
import com.yeepay.yop.sdk.utils.FileUtils;
import com.yeepay.yop.sdk.utils.Sm2CertUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopSmPlatformCredentialsLocalLoader
implements YopPlatformCredentialsLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopSmPlatformCredentialsLocalLoader.class);
    private YopPlatformCredentialsLoader delegate = new YopSmPlatformCredentialsRemoteLoader();
    protected X509Certificate cfcaRoot;
    protected X509Certificate yopInter;
    private String defaultCertPath = "config/certs";
    private String defaultCfcaRootFile = "cfca_root.pem";
    private String defaultYopInterFile = "yop_inter.pem";
    private YopCertStore defaultYopCertStore;

    public YopSmPlatformCredentialsLocalLoader() {
        try {
            if (!EnvUtils.isProd()) {
                String env = EnvUtils.currentEnv();
                String envPrefix = StringUtils.substringBefore((String)env, (String)"_");
                this.defaultCfcaRootFile = envPrefix + "_" + this.defaultCfcaRootFile;
                this.defaultYopInterFile = envPrefix + "_" + this.defaultYopInterFile;
            }
            this.defaultYopCertStore = new YopCertStore(this.defaultCertPath);
            this.cfcaRoot = Sm2CertUtils.getX509Certificate(FileUtils.getResourceAsStream(this.defaultCertPath + "/" + this.defaultCfcaRootFile));
            try {
                Sm2CertUtils.verifyCertificate(null, this.cfcaRoot);
            }
            catch (Exception e) {
                throw new YopClientException("invalid cfca root cert, detail:" + e.getMessage());
            }
            this.yopInter = Sm2CertUtils.getX509Certificate(FileUtils.getResourceAsStream(this.defaultCertPath + "/" + this.defaultYopInterFile));
            try {
                Sm2CertUtils.verifyCertificate((BCECPublicKey)this.cfcaRoot.getPublicKey(), this.yopInter);
            }
            catch (Exception e) {
                throw new YopClientException("invalid yop inter cert, detail:" + e.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("error when load parent certs, ex:", (Throwable)e);
        }
    }

    @Override
    public Map<String, YopPlatformCredentials> load(String appKey, String serialNo) {
        YopCertStore yopCertStore = YopSdkConfigProviderRegistry.getProvider().getConfig().getYopCertStore();
        Map<String, X509Certificate> localCerts = this.loadAndVerifyFromLocal(yopCertStore, serialNo);
        LinkedHashMap<String, YopPlatformCredentials> localCredentials = new LinkedHashMap<String, YopPlatformCredentials>();
        if (MapUtils.isEmpty(localCerts)) {
            localCerts = this.loadAndVerifyFromLocal(this.defaultYopCertStore, serialNo);
        }
        if (MapUtils.isNotEmpty(localCerts)) {
            localCerts.forEach((k, v) -> {
                YopPlatformCredentials cfr_ignored_0 = localCredentials.put((String)k, new YopPlatformCredentialsHolder().withSerialNo(serialNo).withPublicKey(CertTypeEnum.SM2, v.getPublicKey()));
            });
            if (localCredentials.containsKey(serialNo)) {
                return localCredentials;
            }
        }
        LOGGER.info("no available sm2 cert from local, path:{}, serialNo:{}", (Object)yopCertStore.getPath(), (Object)serialNo);
        return this.delegate.load(appKey, serialNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, X509Certificate> loadAndVerifyFromLocal(YopCertStore yopCertStore, String serialNo) {
        LOGGER.debug("load sm2 cert from local, path:{}, serialNo:{}", (Object)yopCertStore.getPath(), (Object)serialNo);
        LinkedHashMap<String, X509Certificate> certMap = new LinkedHashMap<String, X509Certificate>();
        if (StringUtils.isNotBlank((CharSequence)yopCertStore.getPath()) && BooleanUtils.isTrue((Boolean)yopCertStore.getEnable())) {
            InputStream fis = null;
            try {
                String filename = yopCertStore.getPath() + "/" + "yop_platform_sm_cert_" + serialNo + ".cer";
                fis = FileUtils.getResourceAsStream(filename);
                if (null != fis) {
                    X509Certificate cert = Sm2CertUtils.getX509Certificate(fis);
                    Sm2CertUtils.verifyCertificate((BCECPublicKey)this.yopInter.getPublicKey(), cert);
                    String realSerialNo = cert.getSerialNumber().toString();
                    if (!realSerialNo.equals(serialNo)) {
                        LOGGER.warn("wrong file name for cert, serialNo:{}, realSerialNo:{}", (Object)serialNo, (Object)realSerialNo);
                    }
                    certMap.put(realSerialNo, cert);
                }
            }
            catch (Exception e) {
                LOGGER.error("error when load cert from local file, serialNo:" + serialNo + ", ex:", (Throwable)e);
            }
            finally {
                if (null != fis) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return certMap;
    }
}

