/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.auth.credentials.provider;

import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopBaseCredentialsProvider;
import com.yeepay.yop.sdk.config.YopAppConfig;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class YopFixedCredentialsProvider
extends YopBaseCredentialsProvider {
    private final Map<String, YopAppConfig> appConfigs = new HashMap<String, YopAppConfig>();
    private final Map<String, YopCredentials> yopCredentialsMap = new ConcurrentHashMap<String, YopCredentials>();

    @Override
    public final YopCredentials getCredentials(String appId, String credentialType) {
        String key = appId + ":" + credentialType;
        return this.yopCredentialsMap.computeIfAbsent(key, k -> this.buildCredentials(this.getAppConfig(appId), credentialType));
    }

    @Override
    public List<CertTypeEnum> getSupportCertTypes(String appId) {
        return new ArrayList<CertTypeEnum>(this.getAppConfig(appId).getIsvPrivateKeys().keySet());
    }

    private YopAppConfig getAppConfig(String appId) {
        if (!this.appConfigs.containsKey(appId)) {
            this.appConfigs.computeIfAbsent(appId, k -> this.loadAppConfig(appId));
        }
        return this.appConfigs.get(appId);
    }

    protected abstract YopAppConfig loadAppConfig(String var1);

    @Override
    public List<YopCertConfig> getIsvEncryptKey(String appId) {
        return this.getAppConfig(appId).getIsvEncryptKey();
    }

    @Override
    public void removeConfig(String key) {
        this.appConfigs.remove(key);
        this.yopCredentialsMap.clear();
    }
}

