/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.auth.credentials.provider;

import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopPlatformCredentialsProvider;
import com.yeepay.yop.sdk.auth.credentials.provider.loader.YopPlatformCredentialsLoader;
import com.yeepay.yop.sdk.auth.credentials.provider.loader.YopRsaPlatformCredentialsLoader;
import com.yeepay.yop.sdk.auth.credentials.provider.loader.YopSmPlatformCredentialsLocalLoader;
import com.yeepay.yop.sdk.exception.YopServiceException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopFilePlatformCredentialsProvider
implements YopPlatformCredentialsProvider {
    protected static final Logger LOGGER = LoggerFactory.getLogger(YopFilePlatformCredentialsProvider.class);
    private Map<String, YopPlatformCredentials> credentialsMap = new ConcurrentHashMap<String, YopPlatformCredentials>();
    private Map<String, YopPlatformCredentialsLoader> yopPlatformCredentialsLoaderMap = new HashMap<String, YopPlatformCredentialsLoader>(2);

    public YopFilePlatformCredentialsProvider() {
        this.yopPlatformCredentialsLoaderMap.put("rsa", new YopRsaPlatformCredentialsLoader());
        this.yopPlatformCredentialsLoaderMap.put("sm", new YopSmPlatformCredentialsLocalLoader());
    }

    @Override
    public YopPlatformCredentials getYopPlatformCredentials(String appKey, String serialNo) {
        if (StringUtils.isBlank((CharSequence)serialNo)) {
            throw new YopServiceException("serialNo is required");
        }
        YopPlatformCredentials foundCredentials = this.credentialsMap.get(serialNo);
        if (null == foundCredentials) {
            Map<String, YopPlatformCredentials> yopPlatformCredentials;
            String yopPlatformLoader = "sm";
            if (serialNo.equals("rsa")) {
                yopPlatformLoader = serialNo;
            }
            if (MapUtils.isNotEmpty(yopPlatformCredentials = this.yopPlatformCredentialsLoaderMap.get(yopPlatformLoader).load(appKey, serialNo))) {
                yopPlatformCredentials.forEach(this.credentialsMap::put);
            }
            if (yopPlatformCredentials.containsKey(serialNo)) {
                return yopPlatformCredentials.get(serialNo);
            }
        }
        return foundCredentials;
    }

    @Override
    public Map<String, YopPlatformCredentials> reload(String appKey, String serialNo) {
        for (Map.Entry<String, YopPlatformCredentialsLoader> entry : this.yopPlatformCredentialsLoaderMap.entrySet()) {
            YopPlatformCredentialsLoader loader = entry.getValue();
            Map<String, YopPlatformCredentials> yopPlatformCredentials = loader.load(appKey, serialNo);
            if (!MapUtils.isNotEmpty(yopPlatformCredentials)) continue;
            this.credentialsMap.putAll(yopPlatformCredentials);
        }
        return Collections.unmodifiableMap(this.credentialsMap);
    }
}

