/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http.impl.apache;

import com.google.common.base.Preconditions;
import com.yeepay.yop.sdk.client.ClientConfiguration;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.AbstractYopHttpClient;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.Protocol;
import com.yeepay.yop.sdk.http.RetryPolicy;
import com.yeepay.yop.sdk.http.YopHttpResponse;
import com.yeepay.yop.sdk.http.impl.apache.IdleConnectionReaper;
import com.yeepay.yop.sdk.http.impl.apache.YopApacheHttpResponse;
import com.yeepay.yop.sdk.http.impl.apache.YopServerResponseInterceptor;
import com.yeepay.yop.sdk.internal.MultiPartFile;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.YopRequestConfig;
import com.yeepay.yop.sdk.utils.HttpUtils;
import com.yeepay.yop.sdk.utils.RandomUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopHttpClient
extends AbstractYopHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(YopHttpClient.class);
    private final CloseableHttpClient httpClient;
    private final HttpClientConnectionManager connectionManager;
    private final RequestConfig defaultConfig;
    private CredentialsProvider credentialsProvider;
    private HttpHost proxyHttpHost;
    private static final DefaultHostnameVerifier HOSTNAME_VERIFIER_INSTANCE = new DefaultHostnameVerifier();
    private static final ConnectionKeepAliveStrategy KEEP_ALIVE_STRATEGY = new ConnectionKeepAliveStrategy(){

        public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
            try {
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (null == value || !param.equalsIgnoreCase("timeout")) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("KeepAliveDuration Parsed From Server, timeout:{}s.", (Object)value);
                    }
                    return Long.parseLong(value) * 1000L;
                }
            }
            catch (Throwable e) {
                logger.warn("KeepAliveDuration Parsed Fail, ex:{}", (Object)ExceptionUtils.getMessage((Throwable)e));
            }
            return 60000L;
        }
    };

    public YopHttpClient(ClientConfiguration clientConfig) {
        super(clientConfig);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(clientConfig.getConnectionTimeoutInMillis()).setConnectionRequestTimeout(clientConfig.getConnectionRequestTimeoutInMillis()).setSocketTimeout(clientConfig.getSocketTimeoutInMillis()).setStaleConnectionCheckEnabled(true);
        if (clientConfig.getLocalAddress() != null) {
            requestConfigBuilder.setLocalAddress(clientConfig.getLocalAddress());
        }
        String proxyHost = clientConfig.getProxyHost();
        int proxyPort = clientConfig.getProxyPort();
        if (proxyHost != null && proxyPort > 0) {
            this.proxyHttpHost = new HttpHost(proxyHost, proxyPort, clientConfig.getProxyScheme());
            requestConfigBuilder.setProxy(this.proxyHttpHost);
            this.credentialsProvider = new BasicCredentialsProvider();
            String proxyUsername = clientConfig.getProxyUsername();
            String proxyPassword = clientConfig.getProxyPassword();
            String proxyDomain = clientConfig.getProxyDomain();
            String proxyWorkstation = clientConfig.getProxyWorkstation();
            if (proxyUsername != null && proxyPassword != null) {
                this.credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
            }
        }
        this.connectionManager = this.createHttpClientConnectionManager();
        this.defaultConfig = requestConfigBuilder.build();
        this.httpClient = this.createHttpClient(this.connectionManager, this.defaultConfig);
        IdleConnectionReaper.registerConnectionManager(this.connectionManager);
    }

    protected <Input extends BaseRequest> YopHttpResponse doExecute(Request<Input> request, YopRequestConfig yopRequestConfig) throws IOException {
        return new YopApacheHttpResponse(this.httpClient.execute((HttpUriRequest)this.createHttpRequest(request), (HttpContext)this.createHttpContext(request, yopRequestConfig)));
    }

    private HttpClientConnectionManager createHttpClientConnectionManager() {
        SSLConnectionSocketFactory sslSocketFactory;
        try {
            SSLContext sslContext = this.getSSLContext();
            sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)HOSTNAME_VERIFIER_INSTANCE);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new YopClientException("EnvProblem, Fail to Create SSLConnectionSocketFactory, ex:", (Throwable)e);
        }
        RegistryBuilder registryBuilder = RegistryBuilder.create().register(Protocol.HTTPS.toString(), (Object)sslSocketFactory).register(Protocol.HTTP.toString(), (Object)PlainConnectionSocketFactory.getSocketFactory());
        Registry registry = registryBuilder.build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.clientConfig.getSocketTimeoutInMillis()).setTcpNoDelay(true).build());
        connectionManager.setDefaultMaxPerRoute(this.clientConfig.getMaxConnectionsPerRoute());
        connectionManager.setMaxTotal(this.clientConfig.getMaxConnections());
        connectionManager.setValidateAfterInactivity(3000);
        return connectionManager;
    }

    private SSLContext getSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext s;
        String javaVersion = System.getProperty("java.version");
        String tlsVersion = null;
        if (StringUtils.startsWith((CharSequence)javaVersion, (CharSequence)"1.8") || StringUtils.startsWith((CharSequence)javaVersion, (CharSequence)"1.7")) {
            tlsVersion = "TLSv1.2";
        } else if (StringUtils.startsWith((CharSequence)javaVersion, (CharSequence)"1.6")) {
            tlsVersion = "TLSv1.1";
        }
        if (StringUtils.isNotEmpty((CharSequence)tlsVersion)) {
            s = SSLContext.getInstance(tlsVersion);
            s.init(null, null, RandomUtils.secureRandom());
        } else {
            s = SSLContext.getDefault();
        }
        return s;
    }

    private CloseableHttpClient createHttpClient(HttpClientConnectionManager connectionManager, RequestConfig requestConfig) {
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager(connectionManager).disableAutomaticRetries().addInterceptorLast((HttpResponseInterceptor)YopServerResponseInterceptor.INSTANCE).setKeepAliveStrategy(KEEP_ALIVE_STRATEGY);
        int socketBufferSizeInBytes = this.clientConfig.getSocketBufferSizeInBytes();
        if (socketBufferSizeInBytes > 0) {
            builder.setDefaultConnectionConfig(ConnectionConfig.custom().setBufferSize(socketBufferSizeInBytes).build());
        }
        return builder.setDefaultRequestConfig(requestConfig).build();
    }

    protected HttpClientContext createHttpContext(Request<? extends BaseRequest> request, YopRequestConfig yopRequestConfig) {
        HttpClientContext context = HttpClientContext.create();
        if (yopRequestConfig.getConnectTimeout() > 0 || yopRequestConfig.getReadTimeout() > 0) {
            RequestConfig.Builder requestConfigBuilder = RequestConfig.copy((RequestConfig)this.defaultConfig);
            if (yopRequestConfig.getConnectTimeout() > 0) {
                requestConfigBuilder.setConnectTimeout(yopRequestConfig.getConnectTimeout());
            }
            if (yopRequestConfig.getReadTimeout() > 0) {
                requestConfigBuilder.setSocketTimeout(yopRequestConfig.getReadTimeout());
            }
            context.setRequestConfig(requestConfigBuilder.build());
        }
        if (this.credentialsProvider != null) {
            context.setCredentialsProvider(this.credentialsProvider);
        }
        if (this.clientConfig.isProxyPreemptiveAuthenticationEnabled()) {
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(this.proxyHttpHost, (AuthScheme)new BasicScheme());
            context.setAuthCache((AuthCache)authCache);
        }
        return context;
    }

    private HttpRequestBase createHttpRequest(Request<?> request) {
        HttpRequestBase httpRequest;
        String uri = HttpUtils.appendUri((URI)request.getEndpoint(), (String[])new String[]{request.getResourcePath()}).toASCIIString();
        boolean isMultiPart = this.checkForMultiPart(request);
        if (isMultiPart) {
            httpRequest = this.buildMultiPartRequest(uri, request);
        } else {
            boolean putParamsInUri;
            String encodedParams = HttpUtils.encodeParameters(request, (Boolean)false);
            boolean requestHasPayload = request.getContent() != null;
            boolean requestIsPost = request.getHttpMethod() == HttpMethodName.POST;
            boolean bl = putParamsInUri = !requestIsPost || requestHasPayload;
            if (encodedParams != null && putParamsInUri) {
                uri = uri + "?" + encodedParams;
            }
            long contentLength = -1L;
            String contentLengthString = (String)request.getHeaders().get("Content-Length");
            if (contentLengthString != null) {
                contentLength = Long.parseLong(contentLengthString);
            }
            if (request.getHttpMethod() == HttpMethodName.GET) {
                httpRequest = new HttpGet(uri);
            } else if (request.getHttpMethod() == HttpMethodName.PUT) {
                HttpPut putMethod = new HttpPut(uri);
                httpRequest = putMethod;
                if (request.getContent() != null) {
                    putMethod.setEntity((HttpEntity)new InputStreamEntity(request.getContent(), contentLength));
                }
            } else if (request.getHttpMethod() == HttpMethodName.POST) {
                HttpPost postMethod = new HttpPost(uri);
                httpRequest = postMethod;
                if (request.getContent() != null) {
                    postMethod.setEntity((HttpEntity)new InputStreamEntity(request.getContent(), contentLength));
                } else if (encodedParams != null) {
                    postMethod.setEntity((HttpEntity)new StringEntity(encodedParams, Charset.defaultCharset()));
                }
            } else if (request.getHttpMethod() == HttpMethodName.DELETE) {
                httpRequest = new HttpDelete(uri);
            } else if (request.getHttpMethod() == HttpMethodName.HEAD) {
                httpRequest = new HttpHead(uri);
            } else {
                throw new YopClientException("ReqParam Illegal, HttpMethod, name:" + request.getHttpMethod());
            }
        }
        this.buildHttpHeaders(request, new ApacheHeaderBuilder(httpRequest));
        if (!isMultiPart) {
            Preconditions.checkNotNull((Object)httpRequest.getFirstHeader("Content-Type"), (Object)"Content-Type not set");
        }
        return httpRequest;
    }

    private HttpRequestBase buildMultiPartRequest(String uri, Request<?> request) {
        String name;
        HttpPost postMethod = new HttpPost(uri);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (Map.Entry entry : request.getParameters().entrySet()) {
            name = (String)entry.getKey();
            for (String value : (List)entry.getValue()) {
                builder.addTextBody(HttpUtils.normalize((String)name), HttpUtils.normalize((String)value));
            }
        }
        for (Map.Entry entry : request.getMultiPartFiles().entrySet()) {
            name = (String)entry.getKey();
            for (MultiPartFile multiPartFile : (List)entry.getValue()) {
                builder.addBinaryBody(name, (InputStream)multiPartFile.getInputStream(), ContentType.DEFAULT_BINARY, multiPartFile.getFileName());
            }
        }
        postMethod.setEntity(builder.build());
        return postMethod;
    }

    protected long getDelayBeforeNextRetryInMillis(HttpRequestBase method, YopClientException exception, int attempt, RetryPolicy retryPolicy) {
        HttpEntity entity;
        int retries = attempt - 1;
        int maxErrorRetry = retryPolicy.getMaxErrorRetry();
        if (retries >= maxErrorRetry) {
            return -1L;
        }
        if (method instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)method).getEntity()) != null && !entity.isRepeatable()) {
            logger.debug("Entity not repeatable, stop retrying");
            return -1L;
        }
        return Math.min(retryPolicy.getMaxDelayInMillis(), retryPolicy.getDelayBeforeNextRetryInMillis(exception, retries));
    }

    public void shutdown() {
        IdleConnectionReaper.removeConnectionManager(this.connectionManager);
        this.connectionManager.shutdown();
    }

    static class ApacheHeaderBuilder
    implements AbstractYopHttpClient.HeaderBuilder {
        private final HttpRequestBase httpRequest;

        public ApacheHeaderBuilder(HttpRequestBase httpRequest) {
            this.httpRequest = httpRequest;
        }

        public void addHeader(String key, String value) {
            this.httpRequest.addHeader(key, value);
        }
    }
}

