/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zts;

import athenz.shade.zts.javax.ws.rs.client.Client;
import athenz.shade.zts.javax.ws.rs.client.ClientBuilder;
import athenz.shade.zts.javax.ws.rs.client.Entity;
import athenz.shade.zts.javax.ws.rs.client.Invocation;
import athenz.shade.zts.javax.ws.rs.client.WebTarget;
import athenz.shade.zts.javax.ws.rs.core.Response;
import com.yahoo.athenz.zts.AWSTemporaryCredentials;
import com.yahoo.athenz.zts.Access;
import com.yahoo.athenz.zts.AccessTokenResponse;
import com.yahoo.athenz.zts.CertificateAuthorityBundle;
import com.yahoo.athenz.zts.DomainSignedPolicyData;
import com.yahoo.athenz.zts.HostServices;
import com.yahoo.athenz.zts.Identity;
import com.yahoo.athenz.zts.InstanceIdentity;
import com.yahoo.athenz.zts.InstanceRefreshInformation;
import com.yahoo.athenz.zts.InstanceRefreshRequest;
import com.yahoo.athenz.zts.InstanceRegisterInformation;
import com.yahoo.athenz.zts.JWKList;
import com.yahoo.athenz.zts.PublicKeyEntry;
import com.yahoo.athenz.zts.ResourceAccess;
import com.yahoo.athenz.zts.ResourceError;
import com.yahoo.athenz.zts.ResourceException;
import com.yahoo.athenz.zts.RoleAccess;
import com.yahoo.athenz.zts.RoleCertificate;
import com.yahoo.athenz.zts.RoleCertificateRequest;
import com.yahoo.athenz.zts.RoleToken;
import com.yahoo.athenz.zts.SSHCertRequest;
import com.yahoo.athenz.zts.SSHCertificates;
import com.yahoo.athenz.zts.ServiceIdentity;
import com.yahoo.athenz.zts.ServiceIdentityList;
import com.yahoo.athenz.zts.Status;
import com.yahoo.athenz.zts.TenantDomains;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;

public class ZTSRDLGeneratedClient {
    Client client;
    WebTarget base;
    String credsHeader;
    String credsToken;

    public ZTSRDLGeneratedClient(String url) {
        this.client = ClientBuilder.newClient();
        this.base = this.client.target(url);
    }

    public ZTSRDLGeneratedClient(String url, HostnameVerifier hostnameVerifier) {
        this.client = ClientBuilder.newBuilder().hostnameVerifier(hostnameVerifier).build();
        this.base = this.client.target(url);
    }

    public ZTSRDLGeneratedClient(String url, Client rsClient) {
        this.client = rsClient;
        this.base = this.client.target(url);
    }

    public void close() {
        this.client.close();
    }

    public ZTSRDLGeneratedClient setProperty(String name, Object value) {
        this.client = (Client)this.client.property(name, value);
        this.base = this.client.target(this.base.getUri().toString());
        return this;
    }

    public ZTSRDLGeneratedClient addCredentials(String header, String token) {
        this.credsHeader = header;
        this.credsToken = token;
        return this;
    }

    public ResourceAccess getResourceAccess(String action, String resource, String domain, String checkPrincipal) {
        WebTarget target = this.base.path("/access/{action}/{resource}").resolveTemplate("action", action).resolveTemplate("resource", resource);
        if (domain != null) {
            target = target.queryParam("domain", domain);
        }
        if (checkPrincipal != null) {
            target = target.queryParam("principal", checkPrincipal);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return response.readEntity(ResourceAccess.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public ResourceAccess getResourceAccessExt(String action, String resource, String domain, String checkPrincipal) {
        WebTarget target = this.base.path("/access/{action}").resolveTemplate("action", action);
        if (resource != null) {
            target = target.queryParam("resource", resource);
        }
        if (domain != null) {
            target = target.queryParam("domain", domain);
        }
        if (checkPrincipal != null) {
            target = target.queryParam("principal", checkPrincipal);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return response.readEntity(ResourceAccess.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public ServiceIdentity getServiceIdentity(String domainName, String serviceName) {
        WebTarget target = this.base.path("/domain/{domainName}/service/{serviceName}").resolveTemplate("domainName", domainName).resolveTemplate("serviceName", serviceName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return response.readEntity(ServiceIdentity.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public ServiceIdentityList getServiceIdentityList(String domainName) {
        WebTarget target = this.base.path("/domain/{domainName}/service").resolveTemplate("domainName", domainName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return response.readEntity(ServiceIdentityList.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public PublicKeyEntry getPublicKeyEntry(String domainName, String serviceName, String keyId) {
        WebTarget target = this.base.path("/domain/{domainName}/service/{serviceName}/publickey/{keyId}").resolveTemplate("domainName", domainName).resolveTemplate("serviceName", serviceName).resolveTemplate("keyId", keyId);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return response.readEntity(PublicKeyEntry.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public HostServices getHostServices(String host) {
        WebTarget target = this.base.path("/host/{host}/services").resolveTemplate("host", host);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return response.readEntity(HostServices.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public DomainSignedPolicyData getDomainSignedPolicyData(String domainName, String matchingTag, Map<String, List<String>> headers) {
        WebTarget target = this.base.path("/domain/{domainName}/signed_policy_data").resolveTemplate("domainName", domainName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        if (matchingTag != null) {
            invocationBuilder = invocationBuilder.header("If-None-Match", matchingTag);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: 
            case 304: {
                if (headers != null) {
                    headers.put("tag", Arrays.asList((String)response.getHeaders().getFirst("ETag")));
                }
                if (code == 304) {
                    return null;
                }
                return response.readEntity(DomainSignedPolicyData.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public RoleToken getRoleToken(String domainName, String role, Integer minExpiryTime, Integer maxExpiryTime, String proxyForPrincipal) {
        WebTarget target = this.base.path("/domain/{domainName}/token").resolveTemplate("domainName", domainName);
        if (role != null) {
            target = target.queryParam("role", role);
        }
        if (minExpiryTime != null) {
            target = target.queryParam("minExpiryTime", minExpiryTime);
        }
        if (maxExpiryTime != null) {
            target = target.queryParam("maxExpiryTime", maxExpiryTime);
        }
        if (proxyForPrincipal != null) {
            target = target.queryParam("proxyForPrincipal", proxyForPrincipal);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return response.readEntity(RoleToken.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public RoleToken postRoleCertificateRequest(String domainName, String roleName, RoleCertificateRequest req) {
        WebTarget target = this.base.path("/domain/{domainName}/role/{roleName}/token").resolveTemplate("domainName", domainName).resolveTemplate("roleName", roleName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.post(Entity.entity(req, "application/json"));
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return response.readEntity(RoleToken.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Access getAccess(String domainName, String roleName, String principal) {
        WebTarget target = this.base.path("/access/domain/{domainName}/role/{roleName}/principal/{principal}").resolveTemplate("domainName", domainName).resolveTemplate("roleName", roleName).resolveTemplate("principal", principal);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return response.readEntity(Access.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public RoleAccess getRoleAccess(String domainName, String principal) {
        WebTarget target = this.base.path("/access/domain/{domainName}/principal/{principal}").resolveTemplate("domainName", domainName).resolveTemplate("principal", principal);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return response.readEntity(RoleAccess.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public TenantDomains getTenantDomains(String providerDomainName, String userName, String roleName, String serviceName) {
        WebTarget target = this.base.path("/providerdomain/{providerDomainName}/user/{userName}").resolveTemplate("providerDomainName", providerDomainName).resolveTemplate("userName", userName);
        if (roleName != null) {
            target = target.queryParam("roleName", roleName);
        }
        if (serviceName != null) {
            target = target.queryParam("serviceName", serviceName);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return response.readEntity(TenantDomains.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Identity postInstanceRefreshRequest(String domain, String service, InstanceRefreshRequest req) {
        WebTarget target = this.base.path("/instance/{domain}/{service}/refresh").resolveTemplate("domain", domain).resolveTemplate("service", service);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.post(Entity.entity(req, "application/json"));
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return response.readEntity(Identity.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public AWSTemporaryCredentials getAWSTemporaryCredentials(String domainName, String role, Integer durationSeconds, String externalId) {
        WebTarget target = this.base.path("/domain/{domainName}/role/{role}/creds").resolveTemplate("domainName", domainName).resolveTemplate("role", role);
        if (durationSeconds != null) {
            target = target.queryParam("durationSeconds", durationSeconds);
        }
        if (externalId != null) {
            target = target.queryParam("externalId", externalId);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return response.readEntity(AWSTemporaryCredentials.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public InstanceIdentity postInstanceRegisterInformation(InstanceRegisterInformation info, Map<String, List<String>> headers) {
        WebTarget target = this.base.path("/instance");
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.post(Entity.entity(info, "application/json"));
        int code = response.getStatus();
        switch (code) {
            case 201: {
                if (headers != null) {
                    headers.put("location", Arrays.asList((String)response.getHeaders().getFirst("Location")));
                }
                return response.readEntity(InstanceIdentity.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public InstanceIdentity postInstanceRefreshInformation(String provider, String domain, String service, String instanceId, InstanceRefreshInformation info) {
        WebTarget target = this.base.path("/instance/{provider}/{domain}/{service}/{instanceId}").resolveTemplate("provider", provider).resolveTemplate("domain", domain).resolveTemplate("service", service).resolveTemplate("instanceId", instanceId);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.post(Entity.entity(info, "application/json"));
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return response.readEntity(InstanceIdentity.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public InstanceIdentity deleteInstanceIdentity(String provider, String domain, String service, String instanceId) {
        WebTarget target = this.base.path("/instance/{provider}/{domain}/{service}/{instanceId}").resolveTemplate("provider", provider).resolveTemplate("domain", domain).resolveTemplate("service", service).resolveTemplate("instanceId", instanceId);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public CertificateAuthorityBundle getCertificateAuthorityBundle(String name) {
        WebTarget target = this.base.path("/cacerts/{name}").resolveTemplate("name", name);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return response.readEntity(CertificateAuthorityBundle.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Status getStatus() {
        WebTarget target = this.base.path("/status");
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return response.readEntity(Status.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public SSHCertificates postSSHCertRequest(SSHCertRequest certRequest) {
        WebTarget target = this.base.path("/sshcert");
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.post(Entity.entity(certRequest, "application/json"));
        int code = response.getStatus();
        switch (code) {
            case 201: {
                return response.readEntity(SSHCertificates.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public JWKList getJWKList(Boolean rfc) {
        WebTarget target = this.base.path("/oauth2/keys");
        if (rfc != null) {
            target = target.queryParam("rfc", rfc);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return response.readEntity(JWKList.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public AccessTokenResponse postAccessTokenRequest(String request) {
        WebTarget target = this.base.path("/oauth2/token");
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.post(Entity.entity(request, "application/x-www-form-urlencoded"));
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return response.readEntity(AccessTokenResponse.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public RoleCertificate postRoleCertificateRequestExt(RoleCertificateRequest req) {
        WebTarget target = this.base.path("/rolecert");
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, this.credsToken);
        }
        Response response = invocationBuilder.post(Entity.entity(req, "application/json"));
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return response.readEntity(RoleCertificate.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }
}

