/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zts;

import com.yahoo.athenz.zts.RoleToken;
import com.yahoo.athenz.zts.ZTSClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZTSClientTokenCacher {
    private static final Logger LOG = LoggerFactory.getLogger(ZTSClientTokenCacher.class);

    public static void setRoleToken(String signedRoleToken, String roleName, String trustDomain) {
        ZTSClientTokenCacher.setRoleToken(signedRoleToken, roleName);
    }

    public static void setRoleToken(String signedRoleToken, String roleName) {
        com.yahoo.athenz.auth.token.RoleToken rt = new com.yahoo.athenz.auth.token.RoleToken(signedRoleToken);
        String domainName = rt.getDomain();
        String principalName = rt.getPrincipal();
        int index = principalName.lastIndexOf(46);
        if (index == -1) {
            return;
        }
        String tenantDomain = principalName.substring(0, index);
        String tenantService = principalName.substring(index + 1);
        Long expiryTime = rt.getExpiryTime();
        RoleToken roleToken = new RoleToken().setToken(signedRoleToken).setExpiryTime(expiryTime.longValue());
        String key = ZTSClient.getRoleTokenCacheKey(tenantDomain, tenantService, domainName, roleName, null);
        if (LOG.isInfoEnabled()) {
            LOG.info("ZTSTokenCache: cache-add key: {} expiry: {}", (Object)key, (Object)expiryTime);
        }
        ZTSClient.ROLE_TOKEN_CACHE.put(key, roleToken);
    }
}

