/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zts;

import java.util.Objects;

public class ZTSClientNotification {
    private String ztsURL;
    private String role;
    private String type;
    private long expiration;
    private String message;
    private String domain;
    private boolean isInvalidToken;

    public ZTSClientNotification(String ztsURL, String role, String type, long expiration, boolean isInvalid, String domain) {
        this.ztsURL = ztsURL;
        this.role = role;
        this.type = type;
        this.expiration = expiration;
        this.isInvalidToken = isInvalid;
        this.domain = domain;
        this.message = "Fail to get token of type " + this.type + ". ";
        if (this.isInvalidToken) {
            this.message = this.message + " Will not re-attempt to fetch token as token is invalid.";
        }
    }

    public String getZtsURL() {
        return this.ztsURL;
    }

    public String getRole() {
        return this.role;
    }

    public String getType() {
        return this.type;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public boolean getIsInvalidToken() {
        return this.isInvalidToken;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDomain() {
        return this.domain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZTSClientNotification that = (ZTSClientNotification)o;
        return this.ztsURL.equals(that.ztsURL) && Objects.equals(this.domain, that.domain) && Objects.equals(this.role, that.role) && Objects.equals(this.type, that.type) && this.expiration == that.expiration && this.isInvalidToken == that.isInvalidToken && this.message.equals(that.message);
    }

    public int hashCode() {
        return Objects.hash(this.ztsURL, this.domain, this.role, this.type, this.expiration, this.isInvalidToken, this.message);
    }
}

