/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zts;

import athenz.shade.zts.com.fasterxml.jackson.core.type.TypeReference;
import athenz.shade.zts.com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.athenz.zts.RoleAccess;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.impl.copy.ReadWriteCopier;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.SerializerException;
import org.ehcache.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZTSClientCache {
    public static final String ZTS_CLIENT_PROP_CACHE_CLASS = "athenz.zts.client.cache_class";
    public static final String ZTS_CLIENT_PROP_EHCACHE_XML_PATH_ROLE_ACCESS = "athenz.zts.client.ehcache_xml_path";
    private Cache<DomainAndPrincipal, RoleAccess> roleAccessCache;
    private File ehcacheConfigXmlFile;
    private XmlConfiguration xmlConfiguration;
    private CacheManagerBuilder<CacheManager> cacheManagerBuilder;
    private CacheManager cacheManager;
    private static final Logger LOG = LoggerFactory.getLogger(ZTSClientCache.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static ZTSClientCache getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public Cache<DomainAndPrincipal, RoleAccess> getRoleAccessCache() {
        return this.roleAccessCache;
    }

    private static ZTSClientCache createZTSClientCache() throws ExceptionInInitializerError {
        String ztsClientCacheClass = System.getProperty(ZTS_CLIENT_PROP_CACHE_CLASS, ZTSClientCache.class.getName());
        try {
            return (ZTSClientCache)Class.forName(ztsClientCacheClass).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }

    public ZTSClientCache() {
        String ehcacheConfigXmlFileName = System.getProperty(ZTS_CLIENT_PROP_EHCACHE_XML_PATH_ROLE_ACCESS);
        if (ehcacheConfigXmlFileName == null || ehcacheConfigXmlFileName.isEmpty()) {
            LOG.info("ZTSClient cache is disabled: system-property \"{}\" is not set", (Object)ZTS_CLIENT_PROP_EHCACHE_XML_PATH_ROLE_ACCESS);
            return;
        }
        this.ehcacheConfigXmlFile = new File(ehcacheConfigXmlFileName);
        if (!this.ehcacheConfigXmlFile.isFile()) {
            LOG.info("ZTSClient cache is disabled: system-property \"{}\" doesn't reference a file", (Object)ZTS_CLIENT_PROP_EHCACHE_XML_PATH_ROLE_ACCESS);
            this.xmlConfiguration = null;
            return;
        }
        LOG.info("ZTSClient cache is initializing (system-property \"{}\" references the file \"{}\")", (Object)ZTS_CLIENT_PROP_EHCACHE_XML_PATH_ROLE_ACCESS, (Object)this.ehcacheConfigXmlFile.getAbsoluteFile());
        try {
            this.xmlConfiguration = new XmlConfiguration(this.ehcacheConfigXmlFile.toURI().toURL());
        }
        catch (Exception exception) {
            LOG.error("ZTSClient cache is disabled: system-property \"{}\" references the file \"{}\" - which has errors: ", new Object[]{ZTS_CLIENT_PROP_EHCACHE_XML_PATH_ROLE_ACCESS, this.ehcacheConfigXmlFile.getAbsoluteFile(), exception});
            return;
        }
        this.cacheManagerBuilder = CacheManagerBuilder.newCacheManagerBuilder();
        List<Runnable> phase2Executions = this.prepareAllCaches();
        try {
            this.cacheManager = this.cacheManagerBuilder.build(true);
        }
        catch (Exception exception) {
            LOG.error("ZTSClient cache is disabled: system-property \"{}\" references the file \"{}\" - which has build errors: ", new Object[]{ZTS_CLIENT_PROP_EHCACHE_XML_PATH_ROLE_ACCESS, this.ehcacheConfigXmlFile.getAbsoluteFile(), exception});
            return;
        }
        for (Runnable phase2Execution : phase2Executions) {
            if (phase2Execution == null) continue;
            phase2Execution.run();
        }
    }

    private List<Runnable> prepareAllCaches() {
        return Arrays.asList(this.prepareCache("role-access", DomainAndPrincipal.class, RoleAccess.class, null, RoleAccessCopierAndSerializer.class, cache -> {
            this.roleAccessCache = cache;
        }));
    }

    private <K, V> Runnable prepareCache(String cacheName, Class<K> keyClass, Class<V> valueClass, Class<? extends CopierAndSerializer<K>> keyCopierAndSerializerClass, Class<? extends CopierAndSerializer<V>> valueCopierAndSerializerClass, Consumer<Cache<K, V>> cacheIsReady) {
        CacheConfiguration cacheConfiguration;
        try {
            CacheConfigurationBuilder configurationBuilder = this.xmlConfiguration.newCacheConfigurationBuilderFromTemplate(cacheName, keyClass, valueClass);
            if (configurationBuilder == null) {
                LOG.info("ZTSClient \"{}\" cache is disabled: system-property \"{}\" references the file \"{}\" - which has errors in the <ehcache:cache alias=\"{}\"> element.", new Object[]{cacheName, ZTS_CLIENT_PROP_EHCACHE_XML_PATH_ROLE_ACCESS, this.ehcacheConfigXmlFile.getAbsoluteFile(), cacheName});
                return null;
            }
            if (keyCopierAndSerializerClass != null) {
                configurationBuilder = configurationBuilder.withKeySerializer(keyCopierAndSerializerClass).withKeyCopier(keyCopierAndSerializerClass);
            }
            if (valueCopierAndSerializerClass != null) {
                configurationBuilder = configurationBuilder.withValueSerializer(valueCopierAndSerializerClass).withValueCopier(valueCopierAndSerializerClass);
            }
            cacheConfiguration = configurationBuilder.build();
        }
        catch (Exception exception) {
            LOG.info("ZTSClient \"{}\" cache is disabled: system-property \"{}\" references the file \"{}\" - which has errors in the <ehcache:cache alias=\"{}\"> element: ", new Object[]{cacheName, ZTS_CLIENT_PROP_EHCACHE_XML_PATH_ROLE_ACCESS, this.ehcacheConfigXmlFile.getAbsoluteFile(), cacheName, exception});
            return null;
        }
        this.cacheManagerBuilder = this.cacheManagerBuilder.withCache(cacheName, cacheConfiguration);
        return () -> {
            Cache cache = this.cacheManager.getCache(cacheName, keyClass, valueClass);
            if (cache == null) {
                LOG.info("ZTSClient \"{}\" cache is disabled: system-property \"{}\" references the file \"{}\" - which has errors in the <ehcache:cache alias=\"{}\"> element: unknown error", new Object[]{cacheName, ZTS_CLIENT_PROP_EHCACHE_XML_PATH_ROLE_ACCESS, this.ehcacheConfigXmlFile.getAbsoluteFile(), cacheName});
            } else {
                LOG.info("ZTSClient \"{}\" cache is enabled", (Object)cacheName);
                cacheIsReady.accept(cache);
            }
        };
    }

    static /* synthetic */ ZTSClientCache access$000() throws ExceptionInInitializerError {
        return ZTSClientCache.createZTSClientCache();
    }

    public static class RoleAccessCopierAndSerializer
    extends CopierAndSerializer<RoleAccess> {
        private static final TypeReference<RoleAccess> MAP_STRING_STRING = new TypeReference<RoleAccess>(){};

        public RoleAccessCopierAndSerializer() {
        }

        public RoleAccessCopierAndSerializer(ClassLoader classLoader) {
        }

        public ByteBuffer serialize(RoleAccess roleAccess) throws SerializerException {
            CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
            try {
                String json = OBJECT_MAPPER.writeValueAsString(roleAccess);
                return encoder.encode(CharBuffer.wrap(json));
            }
            catch (Exception exception) {
                throw new SerializerException((Throwable)exception);
            }
        }

        public RoleAccess read(ByteBuffer binary) throws SerializerException {
            CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
            try {
                String json = decoder.decode(binary).toString();
                return OBJECT_MAPPER.readValue(json, MAP_STRING_STRING);
            }
            catch (Exception exception) {
                throw new SerializerException((Throwable)exception);
            }
        }

        public RoleAccess copy(RoleAccess roleAccess) {
            RoleAccess clone = new RoleAccess();
            clone.setRoles(roleAccess.getRoles());
            return clone;
        }

        public boolean equals(RoleAccess roleAccess, ByteBuffer binary) throws SerializerException {
            return roleAccess.equals((Object)this.read(binary));
        }
    }

    public static abstract class CopierAndSerializer<T>
    extends ReadWriteCopier<T>
    implements Serializer<T> {
    }

    public static class DomainAndPrincipal
    extends AbstractMap.SimpleEntry<String, String> {
        public DomainAndPrincipal(String domain, String principal) {
            super(domain, principal);
        }
    }

    private static class SingletonHolder {
        public static final ZTSClientCache INSTANCE = ZTSClientCache.access$000();

        private SingletonHolder() {
        }
    }
}

