/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zts;

import athenz.shade.zts.com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.athenz.auth.token.AccessToken;
import com.yahoo.athenz.auth.token.jwts.JwtsSigningKeyResolver;
import com.yahoo.athenz.zts.AccessTokenResponse;
import com.yahoo.athenz.zts.AccessTokenResponseCacheEntry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZTSAccessTokenFileLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ZTSAccessTokenFileLoader.class);
    public static final String ACCESS_TOKEN_PATH_PROPERTY = "athenz.zts.client.accesstoken.path";
    private static final String DEFAULT_ACCESS_TOKEN_DIR_PATH = "/var/lib/sia/tokens/";
    private static final String ROLE_NAME_CONNECTOR = ",";
    private static final String DOMAIN_ROLE_CONNECTOR = ":role:";
    private final String path;
    private JwtsSigningKeyResolver accessSignKeyResolver;
    private ObjectMapper objectMapper = new ObjectMapper();
    private Map<String, String> roleNameMap = new HashMap<String, String>();

    public ZTSAccessTokenFileLoader(JwtsSigningKeyResolver resolver) {
        this.accessSignKeyResolver = resolver;
        this.path = System.getProperty(ACCESS_TOKEN_PATH_PROPERTY, DEFAULT_ACCESS_TOKEN_DIR_PATH);
    }

    public void preload() {
        File dir = new File(this.path);
        if (dir.exists() && dir.isDirectory()) {
            for (File domainDir : dir.listFiles()) {
                if (!domainDir.isDirectory()) continue;
                for (File tokenFile : domainDir.listFiles()) {
                    AccessTokenResponseCacheEntry cacheEntry;
                    if (tokenFile.isDirectory()) continue;
                    AccessTokenResponse accessTokenResponse = null;
                    try {
                        accessTokenResponse = this.objectMapper.readValue(tokenFile, AccessTokenResponse.class);
                    }
                    catch (IOException e) {
                        LOG.error("Failed to load or parse token file: {}", (Object)tokenFile);
                    }
                    if (accessTokenResponse == null || (cacheEntry = new AccessTokenResponseCacheEntry(accessTokenResponse)).isExpired(-1L)) continue;
                    this.addToRoleMap(domainDir.getName(), tokenFile.getName(), accessTokenResponse);
                }
            }
        }
    }

    public AccessTokenResponse lookupAccessTokenFromDisk(String domain, List<String> rolesName) throws IOException {
        String rolesStr = ZTSAccessTokenFileLoader.getRolesStr(domain, rolesName);
        String fileName = this.roleNameMap.get(rolesStr);
        LOG.debug("Trying to fetch access token from disk for domain: {}, roleNames: {}, roleMap key: {}. file name: {}", new Object[]{domain, rolesName, rolesStr, fileName});
        if (fileName == null) {
            return null;
        }
        File tokenFile = new File(this.path + File.separator + domain + File.separator + fileName);
        return this.objectMapper.readValue(tokenFile, AccessTokenResponse.class);
    }

    private static String getRolesStr(String domain, List<String> roleNames) {
        if (roleNames == null || roleNames.isEmpty()) {
            return domain + DOMAIN_ROLE_CONNECTOR + "*";
        }
        ArrayList<String> roleNamesCopy = new ArrayList<String>(roleNames);
        Collections.sort(roleNamesCopy);
        return domain + DOMAIN_ROLE_CONNECTOR + String.join((CharSequence)ROLE_NAME_CONNECTOR, roleNamesCopy);
    }

    private void addToRoleMap(String domain, String fileName, AccessTokenResponse accessTokenResponse) {
        String token = accessTokenResponse.getAccess_token();
        try {
            AccessToken accessToken = new AccessToken(token, this.accessSignKeyResolver);
            List roleNames = accessToken.getScope();
            this.roleNameMap.put(ZTSAccessTokenFileLoader.getRolesStr(domain, roleNames), fileName);
        }
        catch (Exception e) {
            LOG.error("Got error to parse access token file {}, error: {}", (Object)fileName, (Object)e.getMessage());
            return;
        }
    }
}

