/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zts;

import com.yahoo.athenz.zts.AccessTokenResponse;

public class AccessTokenResponseCacheEntry {
    private AccessTokenResponse accessTokenResponse;
    long expiryTime;
    long serverExpirySecs;

    AccessTokenResponseCacheEntry(AccessTokenResponse accessTokenResponse) {
        this.accessTokenResponse = accessTokenResponse;
        this.expiryTime = System.currentTimeMillis() / 1000L + (long)accessTokenResponse.getExpires_in().intValue();
        this.serverExpirySecs = accessTokenResponse.getExpires_in().intValue();
    }

    public boolean isExpired(long expirySeconds) {
        long now = System.currentTimeMillis() / 1000L;
        if (expirySeconds == -1L) {
            return this.expiryTime <= now;
        }
        if (expirySeconds == 0L) {
            expirySeconds = this.serverExpirySecs;
        }
        return this.expiryTime < System.currentTimeMillis() / 1000L + expirySeconds / 4L;
    }

    public AccessTokenResponse accessTokenResponse() {
        AccessTokenResponse tokenResponse = new AccessTokenResponse();
        tokenResponse.setAccess_token(this.accessTokenResponse.getAccess_token());
        tokenResponse.setId_token(this.accessTokenResponse.getId_token());
        tokenResponse.setToken_type(this.accessTokenResponse.getToken_type());
        tokenResponse.setRefresh_token(this.accessTokenResponse.getRefresh_token());
        tokenResponse.setScope(this.accessTokenResponse.getScope());
        tokenResponse.setExpires_in(Integer.valueOf((int)(this.expiryTime - System.currentTimeMillis() / 1000L)));
        return tokenResponse;
    }
}

