/*
 * Decompiled with CFR 0.152.
 */
package athenz.shade.zts.org.glassfish.jersey.process.internal;

import athenz.shade.zts.org.glassfish.jersey.internal.BootstrapConfigurator;
import athenz.shade.zts.org.glassfish.jersey.internal.inject.InjectionManager;
import athenz.shade.zts.org.glassfish.jersey.model.internal.ComponentBag;
import athenz.shade.zts.org.glassfish.jersey.process.internal.ExecutorProviders;
import athenz.shade.zts.org.glassfish.jersey.spi.ExecutorServiceProvider;
import athenz.shade.zts.org.glassfish.jersey.spi.ScheduledExecutorServiceProvider;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractExecutorProvidersConfigurator
implements BootstrapConfigurator {
    private static final Function<Object, ExecutorServiceProvider> CAST_TO_EXECUTOR_PROVIDER = ExecutorServiceProvider.class::cast;
    private static final Function<Object, ScheduledExecutorServiceProvider> CAST_TO_SCHEDULED_EXECUTOR_PROVIDER = ScheduledExecutorServiceProvider.class::cast;

    protected void registerExecutors(InjectionManager injectionManager, ComponentBag componentBag, ExecutorServiceProvider defaultAsyncExecutorProvider, ScheduledExecutorServiceProvider defaultScheduledExecutorProvider) {
        List<ExecutorServiceProvider> customExecutors = Stream.concat(componentBag.getClasses(ComponentBag.EXECUTOR_SERVICE_PROVIDER_ONLY).stream().map(injectionManager::createAndInitialize), componentBag.getInstances(ComponentBag.EXECUTOR_SERVICE_PROVIDER_ONLY).stream()).map(CAST_TO_EXECUTOR_PROVIDER).collect(Collectors.toList());
        customExecutors.add(defaultAsyncExecutorProvider);
        List<ScheduledExecutorServiceProvider> customScheduledExecutors = Stream.concat(componentBag.getClasses(ComponentBag.SCHEDULED_EXECUTOR_SERVICE_PROVIDER_ONLY).stream().map(injectionManager::createAndInitialize), componentBag.getInstances(ComponentBag.SCHEDULED_EXECUTOR_SERVICE_PROVIDER_ONLY).stream()).map(CAST_TO_SCHEDULED_EXECUTOR_PROVIDER).collect(Collectors.toList());
        customScheduledExecutors.add(defaultScheduledExecutorProvider);
        ExecutorProviders.registerExecutorBindings(injectionManager, customExecutors, customScheduledExecutors);
    }
}

