/*
 * Decompiled with CFR 0.152.
 */
package athenz.shade.zts.org.glassfish.jersey.message.internal;

import athenz.shade.zts.javax.inject.Singleton;
import athenz.shade.zts.org.glassfish.jersey.internal.LocalizationMessages;
import athenz.shade.zts.org.glassfish.jersey.message.internal.HttpDateFormat;
import athenz.shade.zts.org.glassfish.jersey.message.internal.HttpHeaderReader;
import athenz.shade.zts.org.glassfish.jersey.message.internal.Utils;
import athenz.shade.zts.org.glassfish.jersey.spi.HeaderDelegateProvider;
import java.text.ParseException;
import java.util.Date;

@Singleton
public class DateProvider
implements HeaderDelegateProvider<Date> {
    @Override
    public boolean supports(Class<?> type) {
        return Date.class.isAssignableFrom(type);
    }

    @Override
    public String toString(Date header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.DATE_IS_NULL());
        return HttpDateFormat.getPreferredDateFormat().format(header);
    }

    @Override
    public Date fromString(String header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.DATE_IS_NULL());
        try {
            return HttpHeaderReader.readDate(header);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Error parsing date '" + header + "'", ex);
        }
    }
}

