/*
 * Decompiled with CFR 0.152.
 */
package athenz.shade.zts.org.glassfish.jersey.message.filtering;

import athenz.shade.zts.javax.inject.Inject;
import athenz.shade.zts.javax.inject.Singleton;
import athenz.shade.zts.javax.ws.rs.ConstrainedTo;
import athenz.shade.zts.javax.ws.rs.RuntimeType;
import athenz.shade.zts.javax.ws.rs.core.Configuration;
import athenz.shade.zts.javax.ws.rs.core.Context;
import athenz.shade.zts.javax.ws.rs.core.SecurityContext;
import athenz.shade.zts.org.glassfish.jersey.internal.inject.InjectionManager;
import athenz.shade.zts.org.glassfish.jersey.message.filtering.SecurityHelper;
import athenz.shade.zts.org.glassfish.jersey.message.filtering.ServerScopeProvider;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;

@Singleton
@ConstrainedTo(value=RuntimeType.SERVER)
final class SecurityServerScopeProvider
extends ServerScopeProvider {
    @Context
    private SecurityContext securityContext;

    @Inject
    public SecurityServerScopeProvider(Configuration config, InjectionManager injectionManager) {
        super(config, injectionManager);
    }

    @Override
    public Set<String> getFilteringScopes(Annotation[] entityAnnotations, boolean defaultIfNotFound) {
        Set<String> filteringScope = super.getFilteringScopes(entityAnnotations, false);
        if (filteringScope.isEmpty()) {
            filteringScope = new HashSet<String>();
            for (String role : SecurityHelper.getProcessedRoles()) {
                if (!this.securityContext.isUserInRole(role)) continue;
                filteringScope.add(SecurityHelper.getRolesAllowedScope(role));
            }
        }
        return this.returnFilteringScopes(filteringScope, defaultIfNotFound);
    }
}

