/*
 * Decompiled with CFR 0.152.
 */
package athenz.shade.zts.org.glassfish.jersey.jackson;

import athenz.shade.zts.javax.ws.rs.core.Configuration;
import athenz.shade.zts.javax.ws.rs.core.Feature;
import athenz.shade.zts.javax.ws.rs.core.FeatureContext;
import athenz.shade.zts.javax.ws.rs.ext.MessageBodyReader;
import athenz.shade.zts.javax.ws.rs.ext.MessageBodyWriter;
import athenz.shade.zts.org.glassfish.jersey.CommonProperties;
import athenz.shade.zts.org.glassfish.jersey.internal.util.PropertiesHelper;
import athenz.shade.zts.org.glassfish.jersey.jackson.internal.DefaultJacksonJaxbJsonProvider;
import athenz.shade.zts.org.glassfish.jersey.jackson.internal.FilteringJacksonJaxbJsonProvider;
import athenz.shade.zts.org.glassfish.jersey.jackson.internal.JacksonFilteringFeature;
import athenz.shade.zts.org.glassfish.jersey.jackson.internal.jackson.jaxrs.base.JsonMappingExceptionMapper;
import athenz.shade.zts.org.glassfish.jersey.jackson.internal.jackson.jaxrs.base.JsonParseExceptionMapper;
import athenz.shade.zts.org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import athenz.shade.zts.org.glassfish.jersey.message.filtering.EntityFilteringFeature;

public class JacksonFeature
implements Feature {
    private final boolean registerExceptionMappers;
    private static final String JSON_FEATURE = JacksonFeature.class.getSimpleName();

    public JacksonFeature() {
        this(true);
    }

    private JacksonFeature(boolean registerExceptionMappers) {
        this.registerExceptionMappers = registerExceptionMappers;
    }

    public static JacksonFeature withExceptionMappers() {
        return new JacksonFeature();
    }

    public static JacksonFeature withoutExceptionMappers() {
        return new JacksonFeature(false);
    }

    @Override
    public boolean configure(FeatureContext context) {
        Configuration config = context.getConfiguration();
        String jsonFeature = CommonProperties.getValue(config.getProperties(), config.getRuntimeType(), "jersey.config.jsonFeature", JSON_FEATURE, String.class);
        if (!JSON_FEATURE.equalsIgnoreCase(jsonFeature)) {
            return false;
        }
        context.property(PropertiesHelper.getPropertyNameForRuntime("jersey.config.jsonFeature", config.getRuntimeType()), JSON_FEATURE);
        if (!config.isRegistered(JacksonJaxbJsonProvider.class)) {
            if (this.registerExceptionMappers) {
                context.register(JsonParseExceptionMapper.class);
                context.register(JsonMappingExceptionMapper.class);
            }
            if (EntityFilteringFeature.enabled(config)) {
                context.register(JacksonFilteringFeature.class);
                context.register(FilteringJacksonJaxbJsonProvider.class, MessageBodyReader.class, MessageBodyWriter.class);
            } else {
                context.register(DefaultJacksonJaxbJsonProvider.class, MessageBodyReader.class, MessageBodyWriter.class);
            }
        }
        return true;
    }
}

