/*
 * Decompiled with CFR 0.152.
 */
package athenz.shade.zts.org.glassfish.jersey.client.filter;

import athenz.shade.zts.javax.ws.rs.core.Feature;
import athenz.shade.zts.javax.ws.rs.core.FeatureContext;
import athenz.shade.zts.org.glassfish.jersey.client.filter.EncodingFilter;
import athenz.shade.zts.org.glassfish.jersey.internal.inject.Providers;
import athenz.shade.zts.org.glassfish.jersey.spi.ContentEncoder;

public class EncodingFeature
implements Feature {
    private final String useEncoding;
    private final Class<?>[] encodingProviders;

    public EncodingFeature(Class<?> ... encodingProviders) {
        this((String)null, encodingProviders);
    }

    public EncodingFeature(String useEncoding, Class<?> ... encoders) {
        this.useEncoding = useEncoding;
        Providers.ensureContract(ContentEncoder.class, encoders);
        this.encodingProviders = encoders;
    }

    @Override
    public boolean configure(FeatureContext context) {
        boolean enable;
        if (this.useEncoding != null && !context.getConfiguration().getProperties().containsKey("jersey.config.client.useEncoding")) {
            context.property("jersey.config.client.useEncoding", this.useEncoding);
        }
        for (Class<?> provider : this.encodingProviders) {
            context.register(provider);
        }
        boolean bl = enable = this.useEncoding != null || this.encodingProviders.length > 0;
        if (enable) {
            context.register(EncodingFilter.class);
        }
        return enable;
    }
}

