/*
 * Decompiled with CFR 0.152.
 */
package athenz.shade.zts.org.apache.http.protocol;

import athenz.shade.zts.org.apache.http.HttpException;
import athenz.shade.zts.org.apache.http.HttpRequest;
import athenz.shade.zts.org.apache.http.HttpRequestInterceptor;
import athenz.shade.zts.org.apache.http.annotation.Contract;
import athenz.shade.zts.org.apache.http.annotation.ThreadingBehavior;
import athenz.shade.zts.org.apache.http.params.HttpParams;
import athenz.shade.zts.org.apache.http.protocol.HttpContext;
import athenz.shade.zts.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s = (String)params.getParameter("http.useragent");
            }
            if (s == null) {
                s = this.userAgent;
            }
            if (s != null) {
                request.addHeader("User-Agent", s);
            }
        }
    }
}

