/*
 * Decompiled with CFR 0.152.
 */
package athenz.shade.zts.org.apache.http.protocol;

import athenz.shade.zts.org.apache.http.HttpEntityEnclosingRequest;
import athenz.shade.zts.org.apache.http.HttpException;
import athenz.shade.zts.org.apache.http.HttpRequest;
import athenz.shade.zts.org.apache.http.HttpRequestInterceptor;
import athenz.shade.zts.org.apache.http.annotation.Contract;
import athenz.shade.zts.org.apache.http.annotation.ThreadingBehavior;
import athenz.shade.zts.org.apache.http.protocol.HttpContext;
import athenz.shade.zts.org.apache.http.protocol.HttpDateGenerator;
import athenz.shade.zts.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

