/*
 * Decompiled with CFR 0.152.
 */
package athenz.shade.zts.org.apache.http.impl.entity;

import athenz.shade.zts.org.apache.http.HttpException;
import athenz.shade.zts.org.apache.http.HttpMessage;
import athenz.shade.zts.org.apache.http.ProtocolException;
import athenz.shade.zts.org.apache.http.annotation.Contract;
import athenz.shade.zts.org.apache.http.annotation.ThreadingBehavior;
import athenz.shade.zts.org.apache.http.entity.ContentLengthStrategy;
import athenz.shade.zts.org.apache.http.impl.entity.LaxContentLengthStrategy;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

