/*
 * Decompiled with CFR 0.152.
 */
package athenz.shade.zts.org.apache.http.impl.cookie;

import athenz.shade.zts.org.apache.http.annotation.Contract;
import athenz.shade.zts.org.apache.http.annotation.ThreadingBehavior;
import athenz.shade.zts.org.apache.http.cookie.CommonCookieAttributeHandler;
import athenz.shade.zts.org.apache.http.cookie.Cookie;
import athenz.shade.zts.org.apache.http.cookie.CookieOrigin;
import athenz.shade.zts.org.apache.http.cookie.CookieRestrictionViolationException;
import athenz.shade.zts.org.apache.http.cookie.MalformedCookieException;
import athenz.shade.zts.org.apache.http.cookie.SetCookie;
import athenz.shade.zts.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import athenz.shade.zts.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

