/*
 * Decompiled with CFR 0.152.
 */
package athenz.shade.zts.org.apache.http.client.protocol;

import athenz.shade.zts.org.apache.http.HttpEntity;
import athenz.shade.zts.org.apache.http.HttpEntityEnclosingRequest;
import athenz.shade.zts.org.apache.http.HttpException;
import athenz.shade.zts.org.apache.http.HttpRequest;
import athenz.shade.zts.org.apache.http.HttpRequestInterceptor;
import athenz.shade.zts.org.apache.http.HttpVersion;
import athenz.shade.zts.org.apache.http.ProtocolVersion;
import athenz.shade.zts.org.apache.http.annotation.Contract;
import athenz.shade.zts.org.apache.http.annotation.ThreadingBehavior;
import athenz.shade.zts.org.apache.http.client.config.RequestConfig;
import athenz.shade.zts.org.apache.http.client.protocol.HttpClientContext;
import athenz.shade.zts.org.apache.http.protocol.HttpContext;
import athenz.shade.zts.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

