/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zpe;

import com.yahoo.athenz.auth.token.AccessToken;
import com.yahoo.athenz.auth.token.RoleToken;
import com.yahoo.athenz.zpe.ZpeClient;
import com.yahoo.athenz.zpe.ZpeUpdPolLoader;
import com.yahoo.rdl.Struct;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZpeUpdater
implements ZpeClient {
    private static final Logger LOG = LoggerFactory.getLogger(ZpeUpdater.class);
    private static final String ZPECLT_POLDIR_DEFAULT;
    private static final ZpeUpdPolLoader POLICYLOADER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(String domain) {
        try {
            ZpeUpdPolLoader zpeUpdPolLoader = POLICYLOADER;
            synchronized (zpeUpdPolLoader) {
                POLICYLOADER.wait(5000L);
            }
        }
        catch (InterruptedException exc) {
            LOG.warn("init: waiting for policy loader to be ready, continuing...");
        }
    }

    @Override
    public Map<String, RoleToken> getRoleTokenCacheMap() {
        return ZpeUpdPolLoader.getRoleTokenCacheMap();
    }

    @Override
    public Map<String, AccessToken> getAccessTokenCacheMap() {
        return ZpeUpdPolLoader.getAccessTokenCacheMap();
    }

    @Override
    public Map<String, List<Struct>> getWildcardAllowAssertions(String domain) {
        return POLICYLOADER.getWildcardRoleAllowMap(domain);
    }

    @Override
    public Map<String, List<Struct>> getRoleAllowAssertions(String domain) {
        return POLICYLOADER.getStandardRoleAllowMap(domain);
    }

    @Override
    public Map<String, List<Struct>> getWildcardDenyAssertions(String domain) {
        return POLICYLOADER.getWildcardRoleDenyMap(domain);
    }

    @Override
    public Map<String, List<Struct>> getRoleDenyAssertions(String domain) {
        return POLICYLOADER.getStandardRoleDenyMap(domain);
    }

    static {
        String rootDir = System.getenv("ROOT");
        if (null == rootDir) {
            rootDir = File.separator + "home" + File.separator + "athenz";
        }
        ZPECLT_POLDIR_DEFAULT = rootDir + File.separator + "var" + File.separator + "zpe";
        String dirName = System.getProperty("athenz.zpe.policy_dir", ZPECLT_POLDIR_DEFAULT);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("static-init: start monitoring policy directory={}", (Object)dirName);
            }
            POLICYLOADER = new ZpeUpdPolLoader(dirName);
            POLICYLOADER.start();
        }
        catch (Exception exc) {
            LOG.error("static-init: failed loading policy files. System property({}) Policy-directory({}})", new Object[]{"athenz.zpe.policy_dir", dirName, exc});
            throw new RuntimeException(exc);
        }
    }
}

