/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zpe;

import com.yahoo.athenz.auth.token.AccessToken;
import com.yahoo.athenz.auth.token.RoleToken;
import com.yahoo.athenz.auth.util.Crypto;
import com.yahoo.athenz.common.utils.SignUtils;
import com.yahoo.athenz.zpe.AuthZpeClient;
import com.yahoo.athenz.zpe.ZpeUpdMonitor;
import com.yahoo.athenz.zpe.match.ZpeMatch;
import com.yahoo.athenz.zpe.match.impl.ZpeMatchAll;
import com.yahoo.athenz.zpe.match.impl.ZpeMatchEqual;
import com.yahoo.athenz.zpe.match.impl.ZpeMatchRegex;
import com.yahoo.athenz.zpe.match.impl.ZpeMatchStartsWith;
import com.yahoo.athenz.zts.Assertion;
import com.yahoo.athenz.zts.AssertionEffect;
import com.yahoo.athenz.zts.DomainSignedPolicyData;
import com.yahoo.athenz.zts.Policy;
import com.yahoo.athenz.zts.PolicyData;
import com.yahoo.athenz.zts.SignedPolicyData;
import com.yahoo.rdl.JSON;
import com.yahoo.rdl.Struct;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZpeUpdPolLoader
implements Closeable {
    private static final Logger LOG;
    static boolean skipPolicyDirCheck;
    static long sleepTimeMillis;
    static long cleanupTokenInterval;
    static long lastRoleTokenCleanup;
    static long lastAccessTokenCleanup;
    private final ScheduledExecutorService scheduledExecutorSvc = Executors.newScheduledThreadPool(1);
    private ZpeUpdMonitor updMonWorker;
    ConcurrentHashMap<String, Map<String, List<Struct>>> domStandardRoleAllowMap = new ConcurrentHashMap();
    ConcurrentHashMap<String, Map<String, List<Struct>>> domWildcardRoleAllowMap = new ConcurrentHashMap();
    ConcurrentHashMap<String, Map<String, List<Struct>>> domStandardRoleDenyMap = new ConcurrentHashMap();
    ConcurrentHashMap<String, Map<String, List<Struct>>> domWildcardRoleDenyMap = new ConcurrentHashMap();
    static ConcurrentHashMap<String, RoleToken> roleTokenCacheMap;
    static ConcurrentHashMap<String, AccessToken> accessTokenCacheMap;
    private final Map<String, ZpeFileStatus> fileStatusRef = new ConcurrentHashMap<String, ZpeFileStatus>();
    private String polDirName;

    ZpeUpdPolLoader(String dirName) {
        if (null != dirName) {
            this.polDirName = dirName;
            try {
                this.loadDb();
            }
            catch (Exception exc) {
                LOG.error("loadDb Failed", (Throwable)exc);
            }
        }
    }

    String getDirName() {
        return this.polDirName;
    }

    Map<String, ZpeFileStatus> getFileStatusMap() {
        return this.fileStatusRef;
    }

    public Map<String, List<Struct>> getWildcardRoleAllowMap(String domainName) {
        return this.domWildcardRoleAllowMap.get(domainName);
    }

    public Map<String, List<Struct>> getStandardRoleAllowMap(String domainName) {
        return this.domStandardRoleAllowMap.get(domainName);
    }

    public Map<String, List<Struct>> getWildcardRoleDenyMap(String domainName) {
        return this.domWildcardRoleDenyMap.get(domainName);
    }

    public Map<String, List<Struct>> getStandardRoleDenyMap(String domainName) {
        return this.domStandardRoleDenyMap.get(domainName);
    }

    public static Map<String, RoleToken> getRoleTokenCacheMap() {
        return roleTokenCacheMap;
    }

    public static Map<String, AccessToken> getAccessTokenCacheMap() {
        return accessTokenCacheMap;
    }

    public void start() throws Exception {
        if (this.polDirName == null) {
            throw new Exception("ERROR: start: no policy directory name, can't monitor data files");
        }
        if (this.updMonWorker == null) {
            this.updMonWorker = new ZpeUpdMonitor(this);
        }
        this.scheduledExecutorSvc.scheduleAtFixedRate(this.updMonWorker, 0L, sleepTimeMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        if (this.updMonWorker != null) {
            this.updMonWorker.cancel();
        }
        this.scheduledExecutorSvc.shutdownNow();
    }

    public static void cleanupRoleTokenCache() {
        long now = System.currentTimeMillis();
        if (now < cleanupTokenInterval + lastRoleTokenCleanup) {
            return;
        }
        long nowSecs = now / 1000L;
        roleTokenCacheMap.entrySet().removeIf(entry -> ((RoleToken)entry.getValue()).getExpiryTime() < nowSecs);
        lastRoleTokenCleanup = now;
    }

    public static void cleanupAccessTokenCache() {
        long now = System.currentTimeMillis();
        if (now < cleanupTokenInterval + lastAccessTokenCleanup) {
            return;
        }
        long nowSecs = now / 1000L;
        accessTokenCacheMap.entrySet().removeIf(entry -> ((AccessToken)entry.getValue()).getExpiryTime() < nowSecs);
        lastAccessTokenCleanup = now;
    }

    void loadDb() {
        if (this.updMonWorker == null) {
            this.updMonWorker = new ZpeUpdMonitor(this);
        }
        if (skipPolicyDirCheck) {
            return;
        }
        File[] polFileNames = this.updMonWorker.loadFileStatus();
        this.loadDb(polFileNames);
    }

    void loadDb(File[] polFileNames) {
        if (polFileNames == null) {
            LOG.error("loadDb: no policy files to load");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("loadDb: START thrd={} directory={}", (Object)Thread.currentThread().getId(), (Object)this.polDirName);
        }
        for (File polFile : polFileNames) {
            String fileName = polFile.getName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("loadDb: START thrd={} file name={}", (Object)Thread.currentThread().getId(), (Object)fileName);
            }
            long lastModMilliSeconds = polFile.lastModified();
            Map<String, ZpeFileStatus> fsmap = this.getFileStatusMap();
            ZpeFileStatus fstat = fsmap.get(fileName);
            if (fstat != null) {
                if (!polFile.exists()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("loadDb: file({}) was deleted or doesn't exist", (Object)fileName);
                    }
                    fsmap.remove(fileName);
                    if (!fstat.validPolFile || fstat.domain == null) continue;
                    this.domStandardRoleAllowMap.put(fstat.domain, new TreeMap());
                    this.domWildcardRoleAllowMap.put(fstat.domain, new TreeMap());
                    this.domStandardRoleDenyMap.put(fstat.domain, new TreeMap());
                    this.domWildcardRoleDenyMap.put(fstat.domain, new TreeMap());
                    continue;
                }
                if (lastModMilliSeconds <= fstat.modifyTimeMillis) {
                    String timeMsg = " last-file-mod-time=" + lastModMilliSeconds;
                    if (fstat.validPolFile) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("loadDb: ignore reload file: {} since up to date: {}", (Object)fileName, (Object)timeMsg);
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("loadDb: retry load file: {} since last load was bad: {}", (Object)fileName, (Object)timeMsg);
                    }
                }
            } else {
                fstat = new ZpeFileStatus(lastModMilliSeconds);
                fsmap.put(fileName, fstat);
            }
            this.loadFile(polFile);
        }
    }

    ZpeMatch getMatchObject(String value) {
        ZpeMatch match;
        if ("*".equals(value)) {
            match = new ZpeMatchAll();
        } else {
            int anyCharMatch = value.indexOf(42);
            int singleCharMatch = value.indexOf(63);
            match = anyCharMatch == -1 && singleCharMatch == -1 ? new ZpeMatchEqual(value) : (anyCharMatch == value.length() - 1 && singleCharMatch == -1 ? new ZpeMatchStartsWith(value.substring(0, value.length() - 1)) : new ZpeMatchRegex(value));
        }
        return match;
    }

    private void loadFile(File polFile) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("loadFile: file({})", (Object)polFile.getName());
        }
        Path path = Paths.get(this.polDirName + File.separator + polFile.getName(), new String[0]);
        DomainSignedPolicyData spols = null;
        try {
            spols = (DomainSignedPolicyData)JSON.fromBytes((byte[])Files.readAllBytes(path), DomainSignedPolicyData.class);
        }
        catch (Exception ex) {
            LOG.error("loadFile: unable to decode policy file={} error: {}", (Object)polFile.getName(), (Object)ex);
        }
        if (spols == null) {
            LOG.error("loadFile: unable to decode domain file={}", (Object)polFile.getName());
            Map<String, ZpeFileStatus> fsmap = this.getFileStatusMap();
            ZpeFileStatus fstat = fsmap.get(polFile.getName());
            if (fstat != null) {
                fstat.validPolFile = false;
            }
            return;
        }
        SignedPolicyData signedPolicyData = spols.getSignedPolicyData();
        String signature = spols.getSignature();
        String keyId = spols.getKeyId();
        boolean verified = false;
        if (signedPolicyData != null) {
            PublicKey pubKey = AuthZpeClient.getZtsPublicKey(keyId);
            if (pubKey == null) {
                LOG.error("loadFile: unable to fetch zts public key for id: {}", (Object)keyId);
            } else {
                verified = Crypto.verify((String)SignUtils.asCanonicalString((SignedPolicyData)signedPolicyData), (PublicKey)pubKey, (String)signature);
            }
        }
        PolicyData policyData = null;
        if (verified) {
            policyData = signedPolicyData.getPolicyData();
            signature = signedPolicyData.getZmsSignature();
            keyId = signedPolicyData.getZmsKeyId();
            if (policyData != null) {
                PublicKey pubKey = AuthZpeClient.getZmsPublicKey(keyId);
                if (pubKey == null) {
                    LOG.error("loadFile: unable to fetch zms public key for id: {}", (Object)keyId);
                } else {
                    verified = Crypto.verify((String)SignUtils.asCanonicalString((PolicyData)policyData), (PublicKey)pubKey, (String)signature);
                }
            }
        }
        if (!verified || policyData == null) {
            LOG.error("loadFile: policy file={} is invalid", (Object)polFile.getName());
            Map<String, ZpeFileStatus> fsmap = this.getFileStatusMap();
            ZpeFileStatus fstat = fsmap.get(polFile.getName());
            if (fstat != null) {
                fstat.validPolFile = false;
            }
            return;
        }
        String domainName = policyData.getDomain();
        if (LOG.isDebugEnabled()) {
            LOG.debug("loadFile: policy file({}) for domain({}) is valid", (Object)polFile.getName(), (Object)domainName);
        }
        TreeMap<String, List> roleStandardAllowMap = new TreeMap<String, List>();
        TreeMap roleWildcardAllowMap = new TreeMap();
        TreeMap roleStandardDenyMap = new TreeMap();
        TreeMap roleWildcardDenyMap = new TreeMap();
        List policies = policyData.getPolicies();
        for (Policy policy : policies) {
            List assertions;
            String pname = policy.getName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("loadFile: domain({}) policy({})", (Object)domainName, (Object)pname);
            }
            if ((assertions = policy.getAssertions()) == null) continue;
            for (Assertion assertion : assertions) {
                Struct strAssert = new Struct();
                strAssert.put("polname", (Object)pname);
                String passertAction = assertion.getAction().toLowerCase();
                ZpeMatch matchStruct = this.getMatchObject(passertAction);
                strAssert.put("actionMatchStruct", (Object)matchStruct);
                String passertResource = assertion.getResource().toLowerCase();
                String rsrc = AuthZpeClient.stripDomainPrefix(passertResource, domainName, passertResource);
                strAssert.put("resource", (Object)rsrc);
                matchStruct = this.getMatchObject(rsrc);
                strAssert.put("resourceMatchStruct", (Object)matchStruct);
                String passertRole = assertion.getRole();
                String pRoleName = AuthZpeClient.stripDomainPrefix(passertRole, domainName, passertRole);
                pRoleName = pRoleName.replaceFirst("^role.", "");
                strAssert.put("role", (Object)pRoleName);
                AssertionEffect passertEffect = assertion.getEffect();
                matchStruct = this.getMatchObject(pRoleName);
                strAssert.put("roleMatchStruct", (Object)matchStruct);
                TreeMap<String, List<Object>> roleMap = passertEffect != null && passertEffect.toString().compareTo("DENY") == 0 ? (matchStruct instanceof ZpeMatchEqual ? roleStandardDenyMap : roleWildcardDenyMap) : (matchStruct instanceof ZpeMatchEqual ? roleStandardAllowMap : roleWildcardAllowMap);
                List assertList = roleMap.computeIfAbsent(pRoleName, k -> new ArrayList());
                assertList.add(strAssert);
            }
        }
        Map<String, ZpeFileStatus> fsmap = this.getFileStatusMap();
        ZpeFileStatus fstat = fsmap.get(polFile.getName());
        if (fstat != null) {
            fstat.validPolFile = true;
            fstat.domain = domainName;
        }
        this.domStandardRoleAllowMap.put(domainName, roleStandardAllowMap);
        this.domWildcardRoleAllowMap.put(domainName, roleWildcardAllowMap);
        this.domStandardRoleDenyMap.put(domainName, roleStandardDenyMap);
        this.domWildcardRoleDenyMap.put(domainName, roleWildcardDenyMap);
    }

    static {
        String errMsg;
        long secs;
        LOG = LoggerFactory.getLogger(ZpeUpdPolLoader.class);
        sleepTimeMillis = -1L;
        cleanupTokenInterval = 600000L;
        lastRoleTokenCleanup = System.currentTimeMillis();
        lastAccessTokenCleanup = System.currentTimeMillis();
        skipPolicyDirCheck = Boolean.parseBoolean(System.getProperty("athenz.zpe.skip_policy_dir_check", "false"));
        String timeoutSecs = System.getProperty("athenz.zpe.monitor_timeout_secs");
        if (timeoutSecs == null) {
            sleepTimeMillis = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
        } else {
            try {
                secs = Long.parseLong(timeoutSecs);
                sleepTimeMillis = TimeUnit.MILLISECONDS.convert(secs, TimeUnit.SECONDS);
            }
            catch (NumberFormatException exc) {
                errMsg = "start: WARNING: Failed using system property(athenz.zpe.monitor_timeout_secs) Got property value=" + timeoutSecs;
                LOG.warn("{}, exc: {}", (Object)errMsg, (Object)exc);
            }
        }
        timeoutSecs = System.getProperty("athenz.zpe.cleanup_tokens_secs");
        if (timeoutSecs != null) {
            try {
                secs = Long.parseLong(timeoutSecs);
                cleanupTokenInterval = TimeUnit.MILLISECONDS.convert(secs, TimeUnit.SECONDS);
            }
            catch (NumberFormatException exc) {
                errMsg = "start: WARNING: Failed using system property(athenz.zpe.cleanup_tokens_secs) Got property value=" + timeoutSecs;
                LOG.warn("{}, exc: {}", (Object)errMsg, (Object)exc);
            }
        }
        roleTokenCacheMap = new ConcurrentHashMap();
        accessTokenCacheMap = new ConcurrentHashMap();
    }

    static class ZpeFileStatus {
        String domain = null;
        long modifyTimeMillis;
        boolean validPolFile;

        ZpeFileStatus(long modTimeMillis) {
            this.modifyTimeMillis = modTimeMillis;
            this.validPolFile = false;
        }
    }
}

