/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.util;

import com.yahoo.athenz.auth.util.CryptoException;
import java.util.Arrays;

public class YBase64 {
    private static final byte[] Y64_ARRAY = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 46, 95};
    public static final byte[] Y64_DECODE_ARRAY = new byte[]{-18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -1, 62, -18, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -18, -18, -18, -18, -18, -18, -18, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -18, -18, -18, -18, 63, -18, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18};

    private static byte decodeByte(int index) {
        if (index < 0 || index >= Y64_DECODE_ARRAY.length) {
            return -18;
        }
        return Y64_DECODE_ARRAY[index];
    }

    private static byte encode1(byte ba) {
        int a = ba & 0xFF;
        int i = a >> 2;
        if (i < 0 || i >= Y64_DECODE_ARRAY.length) {
            return -18;
        }
        return Y64_ARRAY[i];
    }

    private static byte encode2(byte ba, byte bb) {
        int a = ba & 0xFF;
        int b = bb & 0xFF;
        int i = (a << 4 & 0x30) + (b >> 4);
        if (i < 0 || i >= Y64_DECODE_ARRAY.length) {
            return -18;
        }
        return Y64_ARRAY[i];
    }

    private static byte encode3(byte bb, byte bc) {
        int b = bb & 0xFF;
        int c = bc & 0xFF;
        int i = (b << 2 & 0x3C) + (c >> 6);
        if (i < 0 || i >= Y64_DECODE_ARRAY.length) {
            return -18;
        }
        return Y64_ARRAY[i];
    }

    private static byte encode4(byte bc) {
        int i = bc & 0x3F;
        if (i < 0 || i >= Y64_DECODE_ARRAY.length) {
            return -18;
        }
        return Y64_ARRAY[i];
    }

    private static byte decode1(byte a, byte b) {
        return (byte)((a << 2) + (b >> 4));
    }

    private static byte decode2(byte b, byte c) {
        return (byte)((b << 4) + (c >> 2));
    }

    private static byte decode3(byte c, byte d) {
        return (byte)((c << 6) + d);
    }

    public static byte[] decode(byte[] inBytes) {
        if (null == inBytes) {
            throw new NullPointerException("Null input buffer");
        }
        int len = inBytes.length;
        if (len % 4 != 0 && inBytes[len - 1] == 0) {
            --len;
        }
        if (len % 4 != 0) {
            throw new CryptoException("String not padded ie, input string not modulo 4 len =  " + len + " len%4= " + len % 4);
        }
        byte[] out = new byte[YBase64.y64decodeLen(len)];
        int i = 0;
        int j = 0;
        while (i < len) {
            int tlen = len - i;
            if (tlen > 4) {
                tlen = 4;
            }
            if (inBytes[i + 3] == 45) {
                --tlen;
            }
            if (inBytes[i + 2] == 45) {
                --tlen;
            }
            if (inBytes[i + 1] == 45) {
                throw new CryptoException("Too Many pad characters ( this should never happen )");
            }
            byte a = YBase64.decodeByte(inBytes[i++]);
            byte b = YBase64.decodeByte(inBytes[i++]);
            byte c = YBase64.decodeByte(inBytes[i++]);
            byte d = YBase64.decodeByte(inBytes[i++]);
            if (a == -18 || b == -18 || c == -18 || d == -18) {
                throw new CryptoException("Unrecognized characters in y64-encoded input starting at: " + (i - 4));
            }
            if (tlen == 4) {
                out[j++] = YBase64.decode1(a, b);
                out[j++] = YBase64.decode2(b, c);
                out[j++] = YBase64.decode3(c, d);
                continue;
            }
            if (tlen == 3) {
                if ((c & 3) != 0) {
                    throw new CryptoException("Unknown decode error c & 0x03 failed, c-pos: " + (i - 2));
                }
                out[j++] = YBase64.decode1(a, b);
                out[j++] = YBase64.decode2(b, c);
                continue;
            }
            if ((b & 0xF) != 0) {
                throw new CryptoException("Invalid decode. b & 0x0f failed, b-pos: " + (i - 3));
            }
            out[j++] = YBase64.decode1(a, b);
        }
        return Arrays.copyOf(out, j);
    }

    public static byte[] encode(byte[] inBytes) {
        if (null == inBytes) {
            throw new NullPointerException("input buffer was null");
        }
        if (inBytes.length < 1) {
            return new byte[0];
        }
        int len = inBytes.length;
        int encodeLen = YBase64.y64encodeLen(len);
        byte[] out = new byte[encodeLen];
        int j = 0;
        for (int i = 0; i < len; i += 3) {
            byte c;
            byte b;
            byte a;
            int tlen = len - i;
            if (tlen > 3) {
                tlen = 3;
            }
            if (tlen == 1) {
                a = inBytes[i];
                b = 0;
                out[j++] = YBase64.encode1(a);
                out[j++] = YBase64.encode2(a, b);
                out[j++] = 45;
                out[j++] = 45;
                continue;
            }
            if (tlen == 2) {
                a = inBytes[i];
                b = inBytes[i + 1];
                c = 0;
                out[j++] = YBase64.encode1(a);
                out[j++] = YBase64.encode2(a, b);
                out[j++] = YBase64.encode3(b, c);
                out[j++] = 45;
                continue;
            }
            a = inBytes[i];
            b = inBytes[i + 1];
            c = inBytes[i + 2];
            out[j++] = YBase64.encode1(a);
            out[j++] = YBase64.encode2(a, b);
            out[j++] = YBase64.encode3(b, c);
            out[j++] = YBase64.encode4(c);
        }
        return Arrays.copyOf(out, j);
    }

    static int y64decodeLen(int len) {
        return (len + 3) / 4 * 3 + 1;
    }

    static int y64encodeLen(int len) {
        return (len + 2) / 3 * 4 + 1;
    }
}

