/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.util;

import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static boolean isRegexMetaCharacter(char regexChar) {
        switch (regexChar) {
            case '$': 
            case '(': 
            case ')': 
            case '+': 
            case '.': 
            case '[': 
            case '\\': 
            case '^': 
            case '{': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    public static boolean containsMatchCharacter(String name) {
        return name.indexOf(42) != -1 || name.indexOf(63) != -1;
    }

    public static String patternFromGlob(String glob) {
        StringBuilder sb = new StringBuilder("^");
        int len = glob.length();
        for (int i = 0; i < len; ++i) {
            char c = glob.charAt(i);
            if (c == '*') {
                sb.append(".*");
                continue;
            }
            if (c == '?') {
                sb.append('.');
                continue;
            }
            if (StringUtils.isRegexMetaCharacter(c)) {
                sb.append('\\');
            }
            sb.append(c);
        }
        sb.append("$");
        return sb.toString();
    }

    public static boolean containsControlCharacter(String value) {
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            if (value.charAt(i) >= ' ') continue;
            return true;
        }
        return false;
    }

    public static boolean requestUriMatch(String uri, Set<String> uriSet, List<Pattern> uriList) {
        if (uriSet != null && uriSet.contains(uri)) {
            return true;
        }
        if (uriList != null) {
            for (Pattern pattern : uriList) {
                Matcher matcher = pattern.matcher(uri);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }
}

