/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.util;

import com.yahoo.athenz.auth.util.AthenzUtils;
import com.yahoo.athenz.auth.util.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobStringsMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobStringsMatcher.class);
    private final List<String> patterns;

    public GlobStringsMatcher(String systemProperty) {
        List<String> globList = AthenzUtils.splitCommaSeparatedSystemProperty(systemProperty);
        this.patterns = globList.stream().map(glob -> StringUtils.patternFromGlob(glob)).collect(Collectors.toList());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Property: %s, Regex List: %s", systemProperty, Arrays.toString(this.patterns.toArray())));
        }
    }

    public boolean isEmptyPatternsList() {
        return this.patterns == null || this.patterns.size() == 0 || this.patterns.size() == 1 && this.patterns.get(0).equals("^$");
    }

    public boolean isMatch(String value) {
        return this.patterns.stream().anyMatch(pattern -> value.matches((String)pattern));
    }
}

