/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.util;

import com.yahoo.athenz.auth.util.CryptoException;
import com.yahoo.athenz.auth.util.GlobStringsMatcher;
import com.yahoo.athenz.auth.util.YBase64;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.X509KeyUsage;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crypto {
    private static final Logger LOG;
    static final String ATHENZ_CRYPTO_ALGO_RSA = "athenz.crypto.algo_rsa";
    private static final String RSA = "RSA";
    private static final String RSA_SHA1 = "SHA1withRSA";
    private static final String RSA_SHA256 = "SHA256withRSA";
    static final String ATHENZ_CRYPTO_ALGO_ECDSA = "athenz.crypto.algo_ecdsa";
    private static final String ECDSA = "ECDSA";
    private static final String ECDSA_SHA1 = "SHA1withECDSA";
    private static final String ECDSA_SHA256 = "SHA256withECDSA";
    public static final String SHA1 = "SHA1";
    public static final String SHA256 = "SHA256";
    static final String ATHENZ_CRYPTO_BC_PROVIDER = "athenz.crypto.bc_provider";
    private static final String BC_PROVIDER = "BC";
    static final SecureRandom RANDOM;

    private static String getProvider() {
        return System.getProperty(ATHENZ_CRYPTO_BC_PROVIDER, BC_PROVIDER);
    }

    private static String getECDSAAlgo() {
        return System.getProperty(ATHENZ_CRYPTO_ALGO_ECDSA, ECDSA);
    }

    private static String getRSAAlgo() {
        return System.getProperty(ATHENZ_CRYPTO_ALGO_RSA, RSA);
    }

    public static String hmac(String message, String sharedSecret) throws CryptoException {
        byte[] bsig;
        String method = "HmacSHA256";
        try {
            Mac hmac = Mac.getInstance(method);
            SecretKeySpec secretKey = new SecretKeySpec(Crypto.utf8Bytes(sharedSecret), method);
            hmac.init(secretKey);
            bsig = hmac.doFinal(message.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("hmac: Caught NoSuchAlgorithmException, check to make sure the algorithm is supported by the provider.");
            throw new CryptoException(e);
        }
        catch (InvalidKeyException e) {
            LOG.error("hmac: Caught InvalidKeyException, incorrect key type is being used.");
            throw new CryptoException(e);
        }
        return Crypto.ybase64(bsig);
    }

    static String getSignatureAlgorithm(String keyAlgorithm) throws NoSuchAlgorithmException {
        return Crypto.getSignatureAlgorithm(keyAlgorithm, SHA256);
    }

    static String getSignatureAlgorithm(String keyAlgorithm, String digestAlgorithm) throws NoSuchAlgorithmException {
        String signatureAlgorithm = null;
        switch (keyAlgorithm) {
            case "RSA": {
                if (SHA256.equals(digestAlgorithm)) {
                    signatureAlgorithm = RSA_SHA256;
                    break;
                }
                if (!SHA1.equals(digestAlgorithm)) break;
                signatureAlgorithm = RSA_SHA1;
                break;
            }
            case "ECDSA": {
                if (SHA256.equals(digestAlgorithm)) {
                    signatureAlgorithm = ECDSA_SHA256;
                    break;
                }
                if (!SHA1.equals(digestAlgorithm)) break;
                signatureAlgorithm = ECDSA_SHA1;
            }
        }
        if (signatureAlgorithm == null) {
            LOG.error("getSignatureAlgorithm: Unknown key algorithm: {} digest algorithm: {}", (Object)keyAlgorithm, (Object)digestAlgorithm);
            throw new NoSuchAlgorithmException();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signature Algorithm: {}", (Object)signatureAlgorithm);
        }
        return signatureAlgorithm;
    }

    public static String sign(String message, PrivateKey key, String digestAlgorithm) throws CryptoException {
        try {
            String signatureAlgorithm = Crypto.getSignatureAlgorithm(key.getAlgorithm(), digestAlgorithm);
            Signature signer = Signature.getInstance(signatureAlgorithm, BC_PROVIDER);
            signer.initSign(key);
            signer.update(Crypto.utf8Bytes(message));
            byte[] sig = signer.sign();
            return Crypto.ybase64(sig);
        }
        catch (NoSuchProviderException e) {
            LOG.error("sign: Caught NoSuchProviderException, check to make sure the provider is loaded correctly.");
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("sign: Caught NoSuchAlgorithmException, check to make sure the algorithm is supported by the provider.");
            throw new CryptoException(e);
        }
        catch (SignatureException e) {
            LOG.error("sign: Caught SignatureException.");
            throw new CryptoException(e);
        }
        catch (InvalidKeyException e) {
            LOG.error("sign: Caught InvalidKeyException, incorrect key type is being used.");
            throw new CryptoException(e);
        }
    }

    public static byte[] sign(byte[] message, PrivateKey key, String digestAlgorithm) throws CryptoException {
        try {
            String signatureAlgorithm = Crypto.getSignatureAlgorithm(key.getAlgorithm(), digestAlgorithm);
            Signature signer = Signature.getInstance(signatureAlgorithm, BC_PROVIDER);
            signer.initSign(key);
            signer.update(message);
            return signer.sign();
        }
        catch (NoSuchProviderException e) {
            LOG.error("sign: Caught NoSuchProviderException, check to make sure the provider is loaded correctly.");
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("sign: Caught NoSuchAlgorithmException, check to make sure the algorithm is supported by the provider.");
            throw new CryptoException(e);
        }
        catch (SignatureException e) {
            LOG.error("sign: Caught SignatureException.");
            throw new CryptoException(e);
        }
        catch (InvalidKeyException e) {
            LOG.error("sign: Caught InvalidKeyException, incorrect key type is being used.");
            throw new CryptoException(e);
        }
    }

    public static String sign(String message, PrivateKey key) throws CryptoException {
        return Crypto.sign(message, key, SHA256);
    }

    public static boolean verify(String message, PublicKey key, String signature, String digestAlgorithm) throws CryptoException {
        try {
            byte[] sig = Crypto.ybase64Decode(signature);
            String signatureAlgorithm = Crypto.getSignatureAlgorithm(key.getAlgorithm(), digestAlgorithm);
            Signature signer = Signature.getInstance(signatureAlgorithm, BC_PROVIDER);
            signer.initVerify(key);
            signer.update(Crypto.utf8Bytes(message));
            return signer.verify(sig);
        }
        catch (NoSuchProviderException e) {
            LOG.error("verify: Caught NoSuchProviderException, check to make sure the provider is loaded correctly.");
            throw new CryptoException(e);
        }
        catch (InvalidKeyException e) {
            LOG.error("verify: Caught InvalidKeyException, invalid key type is being used.");
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("verify: Caught NoSuchAlgorithmException, check to make sure the algorithm is supported by the provider.");
            throw new CryptoException(e);
        }
        catch (SignatureException e) {
            LOG.error("verify: Caught SignatureException.");
            throw new CryptoException(e);
        }
    }

    public static boolean verify(String message, PublicKey key, String signature) throws CryptoException {
        return Crypto.verify(message, key, signature, SHA256);
    }

    public static boolean verify(byte[] message, PublicKey key, byte[] signature, String digestAlgorithm) throws CryptoException {
        try {
            String signatureAlgorithm = Crypto.getSignatureAlgorithm(key.getAlgorithm(), digestAlgorithm);
            Signature signer = Signature.getInstance(signatureAlgorithm, BC_PROVIDER);
            signer.initVerify(key);
            signer.update(message);
            return signer.verify(signature);
        }
        catch (NoSuchProviderException e) {
            LOG.error("verify: Caught NoSuchProviderException, check to make sure the provider is loaded correctly.");
            throw new CryptoException(e);
        }
        catch (InvalidKeyException e) {
            LOG.error("verify: Caught InvalidKeyException, invalid key type is being used.");
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("verify: Caught NoSuchAlgorithmException, check to make sure the algorithm is supported by the provider.");
            throw new CryptoException(e);
        }
        catch (SignatureException e) {
            LOG.error("verify: Caught SignatureException.");
            throw new CryptoException(e);
        }
    }

    static String utf8String(byte[] b) {
        return new String(b, StandardCharsets.UTF_8);
    }

    static byte[] utf8Bytes(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] sha256(byte[] data) throws CryptoException {
        MessageDigest sha256;
        try {
            sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("sha256: Caught NoSuchAlgorithmException, check to make sure the algorithm is supported by the provider.");
            throw new CryptoException(e);
        }
        return sha256.digest(data);
    }

    public static byte[] sha256(String text) throws CryptoException {
        return Crypto.sha256(Crypto.utf8Bytes(text));
    }

    public static String ybase64(byte[] data) {
        return Crypto.utf8String(YBase64.encode(data));
    }

    public static byte[] ybase64Decode(String b64) {
        return YBase64.decode(Crypto.utf8Bytes(b64));
    }

    public static String ybase64DecodeString(String b64) {
        return Crypto.utf8String(Crypto.ybase64Decode(b64));
    }

    public static String ybase64EncodeString(String str) {
        return Crypto.utf8String(YBase64.encode(Crypto.utf8Bytes(str)));
    }

    public static String x509CertificatesToPEM(X509Certificate[] x509Certs) throws CryptoException {
        StringWriter sw = new StringWriter();
        try (JcaPEMWriter pw = new JcaPEMWriter((Writer)sw);){
            for (X509Certificate x509Cert : x509Certs) {
                pw.writeObject((Object)x509Cert);
            }
        }
        catch (IOException ex) {
            LOG.error("Unable to generate PEM output", (Throwable)ex);
            throw new CryptoException(ex);
        }
        return sw.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate[] loadX509Certificates(String certsFile) throws CryptoException {
        File certFile = new File(certsFile);
        try (FileInputStream certStream = new FileInputStream(certFile);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            List certs = (List)cf.generateCertificates(certStream);
            if (certs.isEmpty()) {
                throw new CryptoException("Certificate file contains empty certificate or an invalid certificate.");
            }
            X509Certificate[] x509CertificateArray = certs.toArray(new X509Certificate[certs.size()]);
            return x509CertificateArray;
        }
        catch (IOException ex) {
            LOG.error("loadX509Certificates: unable to process file: {}", (Object)certFile.getAbsolutePath());
            throw new CryptoException(ex);
        }
        catch (CertificateException ex) {
            LOG.error("Unable to load certificates", (Throwable)ex);
            throw new CryptoException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate loadX509Certificate(File certFile) throws CryptoException {
        try (FileReader fileReader = new FileReader(certFile);){
            X509Certificate x509Certificate = Crypto.loadX509Certificate(fileReader);
            return x509Certificate;
        }
        catch (FileNotFoundException e) {
            LOG.error("loadX509Certificate: Caught FileNotFoundException while attempting to load certificate for file: {}", (Object)certFile.getAbsolutePath());
            throw new CryptoException(e);
        }
        catch (IOException e) {
            LOG.error("loadX509Certificate: Caught IOException while attempting to load certificate for file: {}", (Object)certFile.getAbsolutePath());
            throw new CryptoException(e);
        }
    }

    public static X509Certificate loadX509Certificate(String pemEncoded) throws CryptoException {
        return Crypto.loadX509Certificate(new StringReader(pemEncoded));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate loadX509Certificate(Reader reader) throws CryptoException {
        block23: {
            try {
                Throwable throwable = null;
                try (PEMParser pemParser = new PEMParser(reader);){
                    Object pemObj = pemParser.readObject();
                    if (pemObj instanceof X509Certificate) {
                        X509Certificate x509Certificate = (X509Certificate)pemObj;
                        return x509Certificate;
                    }
                    if (!(pemObj instanceof X509CertificateHolder)) break block23;
                    try {
                        X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider(BC_PROVIDER).getCertificate((X509CertificateHolder)pemObj);
                        return x509Certificate;
                    }
                    catch (CertificateException ex) {
                        try {
                            LOG.error("loadX509Certificate: Caught CertificateException, unable to parse X509 certificate: {}", (Object)ex.getMessage());
                            throw new CryptoException(ex);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            catch (IOException ex) {
                LOG.error("loadX509Certificate: Caught IOException, unable to parse X509 certificate: {}", (Object)ex.getMessage());
                throw new CryptoException(ex);
            }
        }
        return null;
    }

    public static PublicKey loadPublicKey(String pemEncoded) throws CryptoException {
        return Crypto.loadPublicKey(new StringReader(pemEncoded));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PublicKey loadPublicKey(Reader r) throws CryptoException {
        try (PEMParser pemReader = new PEMParser(r);){
            Object pemObj = pemReader.readObject();
            JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
            X9ECParameters ecParam = null;
            if (pemObj instanceof ASN1ObjectIdentifier) {
                ASN1ObjectIdentifier ecOID = (ASN1ObjectIdentifier)pemObj;
                ecParam = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)ecOID);
                if (ecParam == null) {
                    throw new PEMException("Unable to find EC Parameter for the given curve oid: " + ((ASN1ObjectIdentifier)pemObj).getId());
                }
                pemObj = pemReader.readObject();
            } else if (pemObj instanceof X9ECParameters) {
                ecParam = (X9ECParameters)pemObj;
                pemObj = pemReader.readObject();
            }
            SubjectPublicKeyInfo keyInfo = pemObj instanceof X509CertificateHolder ? ((X509CertificateHolder)pemObj).getSubjectPublicKeyInfo() : (SubjectPublicKeyInfo)pemObj;
            PublicKey pubKey = pemConverter.getPublicKey(keyInfo);
            if (ecParam != null && ECDSA.equals(pubKey.getAlgorithm())) {
                ECParameterSpec ecSpec = new ECParameterSpec(ecParam.getCurve(), ecParam.getG(), ecParam.getN(), ecParam.getH(), ecParam.getSeed());
                KeyFactory keyFactory = KeyFactory.getInstance(Crypto.getECDSAAlgo(), Crypto.getProvider());
                ECPublicKeySpec keySpec = new ECPublicKeySpec(((BCECPublicKey)pubKey).getQ(), ecSpec);
                pubKey = keyFactory.generatePublic((KeySpec)keySpec);
            }
            PublicKey publicKey = pubKey;
            return publicKey;
        }
        catch (NoSuchProviderException e) {
            LOG.error("loadPublicKey: Caught NoSuchProviderException, check to make sure the provider is loaded correctly.");
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("loadPublicKey: Caught NoSuchAlgorithmException, check to make sure the algorithm is supported by the provider.");
            throw new CryptoException(e);
        }
        catch (InvalidKeySpecException e) {
            LOG.error("loadPublicKey: Caught InvalidKeySpecException, invalid key spec is being used.");
            throw new CryptoException("InvalidKeySpecException");
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PublicKey loadPublicKey(File f) throws CryptoException {
        try (FileReader fileReader = new FileReader(f);){
            PublicKey publicKey = Crypto.loadPublicKey(fileReader);
            return publicKey;
        }
        catch (FileNotFoundException e) {
            LOG.error("loadPublicKey: Caught FileNotFoundException while attempting to load public key for file: " + f.getAbsolutePath());
            throw new CryptoException(e);
        }
        catch (IOException e) {
            LOG.error("loadPublicKey: Caught IOException while attempting to load public key for file: " + f.getAbsolutePath());
            throw new CryptoException(e);
        }
    }

    public static PublicKey extractPublicKey(PrivateKey privateKey) throws CryptoException {
        PublicKey publicKey;
        switch (privateKey.getAlgorithm()) {
            case "RSA": {
                try {
                    KeyFactory kf = KeyFactory.getInstance(Crypto.getRSAAlgo(), Crypto.getProvider());
                    RSAPrivateCrtKey rsaCrtKey = (RSAPrivateCrtKey)privateKey;
                    RSAPublicKeySpec keySpec = new RSAPublicKeySpec(rsaCrtKey.getModulus(), rsaCrtKey.getPublicExponent());
                    publicKey = kf.generatePublic(keySpec);
                    break;
                }
                catch (NoSuchProviderException ex) {
                    LOG.error("extractPublicKey: RSA - Caught NoSuchProviderException exception: {}", (Object)ex.getMessage());
                    throw new CryptoException(ex);
                }
                catch (NoSuchAlgorithmException ex) {
                    LOG.error("extractPublicKey: RSA - Caught NoSuchAlgorithmException exception: {}", (Object)ex.getMessage());
                    throw new CryptoException(ex);
                }
                catch (InvalidKeySpecException ex) {
                    LOG.error("extractPublicKey: RSA - Caught InvalidKeySpecException exception: {}", (Object)ex.getMessage());
                    throw new CryptoException(ex);
                }
            }
            case "ECDSA": {
                try {
                    KeyFactory kf = KeyFactory.getInstance(Crypto.getECDSAAlgo(), Crypto.getProvider());
                    BCECPrivateKey ecPrivKey = (BCECPrivateKey)privateKey;
                    FixedPointCombMultiplier ecMultiplier = new FixedPointCombMultiplier();
                    ECParameterSpec ecParamSpec = ecPrivKey.getParameters();
                    ECPoint ecPointQ = ecMultiplier.multiply(ecParamSpec.getG(), ecPrivKey.getD());
                    ECPublicKeySpec keySpec = new ECPublicKeySpec(ecPointQ, ecParamSpec);
                    publicKey = kf.generatePublic((KeySpec)keySpec);
                    break;
                }
                catch (NoSuchProviderException ex) {
                    LOG.error("extractPublicKey: ECDSA - Caught NoSuchProviderException exception: {}", (Object)ex.getMessage());
                    throw new CryptoException(ex);
                }
                catch (NoSuchAlgorithmException ex) {
                    LOG.error("extractPublicKey: ECDSA - Caught NoSuchAlgorithmException exception: {}", (Object)ex.getMessage());
                    throw new CryptoException(ex);
                }
                catch (InvalidKeySpecException ex) {
                    LOG.error("extractPublicKey: ECDSA - Caught InvalidKeySpecException exception: {}", (Object)ex.getMessage());
                    throw new CryptoException(ex);
                }
            }
            default: {
                String msg = "Unsupported Key Algorithm: " + privateKey.getAlgorithm();
                LOG.error("extractPublicKey: {}", (Object)msg);
                throw new CryptoException(msg);
            }
        }
        return publicKey;
    }

    public static PrivateKey loadPrivateKey(String pemEncoded) throws CryptoException {
        return Crypto.loadPrivateKey(new StringReader(pemEncoded), null);
    }

    public static PrivateKey loadPrivateKey(Reader reader) throws CryptoException {
        return Crypto.loadPrivateKey(reader, null);
    }

    public static PrivateKey loadPrivateKey(File file) throws CryptoException {
        return Crypto.loadPrivateKey(file, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivateKey loadPrivateKey(File file, String pwd) throws CryptoException {
        try (FileReader fileReader = new FileReader(file);){
            PrivateKey privateKey = Crypto.loadPrivateKey(fileReader, pwd);
            return privateKey;
        }
        catch (FileNotFoundException e) {
            LOG.error("loadPrivateKey: Caught FileNotFoundException while attempting to load private key for file: " + file.getAbsolutePath());
            throw new CryptoException(e);
        }
        catch (IOException e) {
            LOG.error("loadPrivateKey: Caught IOException while attempting to load private key for file: " + file.getAbsolutePath());
            throw new CryptoException(e);
        }
    }

    public static PrivateKey loadPrivateKey(String pemEncoded, String pwd) throws CryptoException {
        return Crypto.loadPrivateKey(new StringReader(pemEncoded), pwd);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivateKey loadPrivateKey(Reader reader, String pwd) throws CryptoException {
        try (PEMParser pemReader = new PEMParser(reader);){
            PrivateKeyInfo pKeyInfo;
            Key privKey = null;
            X9ECParameters ecParam = null;
            Object pemObj = pemReader.readObject();
            if (pemObj instanceof ASN1ObjectIdentifier) {
                ASN1ObjectIdentifier ecOID = (ASN1ObjectIdentifier)pemObj;
                ecParam = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)ecOID);
                if (ecParam == null) {
                    throw new PEMException("Unable to find EC Parameter for the given curve oid: " + ((ASN1ObjectIdentifier)pemObj).getId());
                }
                pemObj = pemReader.readObject();
            } else if (pemObj instanceof X9ECParameters) {
                ecParam = (X9ECParameters)pemObj;
                pemObj = pemReader.readObject();
            }
            if (pemObj instanceof PEMKeyPair) {
                pKeyInfo = ((PEMKeyPair)pemObj).getPrivateKeyInfo();
                JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
                privKey = pemConverter.getPrivateKey(pKeyInfo);
            } else if (pemObj instanceof PKCS8EncryptedPrivateKeyInfo) {
                pKeyInfo = (PKCS8EncryptedPrivateKeyInfo)pemObj;
                if (pwd == null) {
                    throw new CryptoException("No password specified to decrypt encrypted private key");
                }
                InputDecryptorProvider pkcs8Prov = new JceOpenSSLPKCS8DecryptorProviderBuilder().setProvider(BC_PROVIDER).build(pwd.toCharArray());
                PrivateKeyInfo privateKeyInfo = pKeyInfo.decryptPrivateKeyInfo(pkcs8Prov);
                JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
                privKey = pemConverter.getPrivateKey(privateKeyInfo);
            }
            if (ecParam != null && privKey != null && ECDSA.equals(privKey.getAlgorithm())) {
                ECParameterSpec ecSpec = new ECParameterSpec(ecParam.getCurve(), ecParam.getG(), ecParam.getN(), ecParam.getH(), ecParam.getSeed());
                KeyFactory keyFactory = KeyFactory.getInstance(Crypto.getECDSAAlgo(), Crypto.getProvider());
                ECPrivateKeySpec keySpec = new ECPrivateKeySpec(((BCECPrivateKey)privKey).getS(), ecSpec);
                privKey = keyFactory.generatePrivate((KeySpec)keySpec);
            }
            Key key = privKey;
            return key;
        }
        catch (PEMException e) {
            LOG.error("loadPrivateKey: Caught PEMException, problem with format of key detected.");
            throw new CryptoException((IOException)((Object)e));
        }
        catch (NoSuchProviderException e) {
            LOG.error("loadPrivateKey: Caught NoSuchProviderException, check to make sure the provider is loaded correctly.");
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("loadPrivateKey: Caught NoSuchAlgorithmException, check to make sure the algorithm is supported by the provider.");
            throw new CryptoException(e);
        }
        catch (InvalidKeySpecException e) {
            LOG.error("loadPrivateKey: Caught InvalidKeySpecException, invalid key spec is being used.");
            throw new CryptoException(e);
        }
        catch (OperatorCreationException e) {
            LOG.error("loadPrivateKey: Caught OperatorCreationException when creating JceOpenSSLPKCS8DecryptorProviderBuilder.");
            throw new CryptoException(e);
        }
        catch (PKCSException e) {
            LOG.error("loadPrivateKey: Caught PKCSException when decrypting private key.");
            throw new CryptoException(e);
        }
        catch (IOException e) {
            LOG.error("loadPrivateKey: Caught IOException, while trying to read key.");
            throw new CryptoException(e);
        }
    }

    public static PrivateKey generateRSAPrivateKey(int bits) throws CryptoException {
        KeyPairGenerator keyGen;
        try {
            keyGen = KeyPairGenerator.getInstance(RSA);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("generatePrivateKey: Caught NoSuchAlgorithmException, check to make sure the algorithm is supported by the provider.");
            throw new CryptoException(e);
        }
        keyGen.initialize(bits);
        return keyGen.genKeyPair().getPrivate();
    }

    public static String randomSalt() {
        long v = RANDOM.nextLong();
        return Long.toHexString(v);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String encodedFile(File f) {
        try (FileInputStream in = new FileInputStream(f);){
            int fileLength = (int)f.length();
            byte[] buf = new byte[fileLength];
            if (in.read(buf) != fileLength) {
                LOG.error("encodedFile: Unable to read {} bytes from file {}", (Object)fileLength, (Object)f.getAbsolutePath());
                throw new IOException("Unable to read file");
            }
            String string = Crypto.ybase64(buf);
            return string;
        }
        catch (FileNotFoundException e) {
            LOG.error("encodedFile: Caught FileNotFoundException while attempting to read encoded file: " + f.getAbsolutePath());
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            LOG.error("encodedFile: Caught IOException while attempting to read encoded file: " + f.getAbsolutePath());
            throw new RuntimeException(e);
        }
    }

    public static String encodedFile(FileInputStream is) {
        try {
            int readBytes;
            byte[] buf = new byte[4096];
            String contents = null;
            while ((readBytes = is.read(buf)) > 0) {
                if (contents == null) {
                    contents = new String(buf, 0, readBytes - 1);
                    continue;
                }
                contents = contents.concat(new String(buf, 0, readBytes - 1));
            }
            if (contents == null) {
                throw new IOException("Unable to read any data from file stream");
            }
            return Crypto.ybase64(Crypto.utf8Bytes(contents));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PKCS10CertificationRequest getPKCS10CertRequest(String csr) {
        if (csr == null || csr.isEmpty()) {
            LOG.error("getPKCS10CertRequest: CSR is null or empty");
            throw new CryptoException("CSR is null or empty");
        }
        try {
            StringReader csrReader = new StringReader(csr);
            try (PEMParser pemParser = new PEMParser((Reader)csrReader);){
                Object pemObj = pemParser.readObject();
                if (!(pemObj instanceof PKCS10CertificationRequest)) return null;
                PKCS10CertificationRequest pKCS10CertificationRequest = (PKCS10CertificationRequest)pemObj;
                return pKCS10CertificationRequest;
            }
        }
        catch (IOException ex) {
            LOG.error("getPKCS10CertRequest: unable to parse csr: {}", (Object)ex.getMessage());
            throw new CryptoException(ex);
        }
    }

    public static String extractX509CSRSubjectField(PKCS10CertificationRequest certReq, ASN1ObjectIdentifier id) {
        X500Name x500name = certReq.getSubject();
        if (x500name == null) {
            return null;
        }
        RDN[] rdns = x500name.getRDNs(id);
        if (rdns == null || rdns.length == 0) {
            return null;
        }
        if (rdns.length != 1) {
            throw new CryptoException("CSR Subject contains multiple values for the same field.");
        }
        return IETFUtils.valueToString((ASN1Encodable)rdns[0].getFirst().getValue());
    }

    public static String extractX509CSRCommonName(PKCS10CertificationRequest certReq) {
        return Crypto.extractX509CSRSubjectField(certReq, BCStyle.CN);
    }

    public static String extractX509CSRSubjectOField(PKCS10CertificationRequest certReq) {
        return Crypto.extractX509CSRSubjectField(certReq, BCStyle.O);
    }

    public static String extractX509CSRSubjectOUField(PKCS10CertificationRequest certReq) {
        return Crypto.extractX509CSRSubjectField(certReq, BCStyle.OU);
    }

    private static List<String> extractX509CSRSANField(PKCS10CertificationRequest certReq, int tagNo) {
        Attribute[] attributes;
        ArrayList<String> values = new ArrayList<String>();
        for (Attribute attribute : attributes = certReq.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest)) {
            for (ASN1Encodable value : attribute.getAttributeValues()) {
                Extensions extensions = Extensions.getInstance((Object)value);
                GeneralNames gns = GeneralNames.fromExtensions((Extensions)extensions, (ASN1ObjectIdentifier)Extension.subjectAlternativeName);
                if (gns == null) continue;
                for (GeneralName name : gns.getNames()) {
                    if (name.getTagNo() != tagNo) continue;
                    values.add(((DERIA5String)name.getName()).getString());
                }
            }
        }
        return values;
    }

    public static String extractX509CSREmail(PKCS10CertificationRequest certReq) {
        List<String> emails = Crypto.extractX509CSRSANField(certReq, 1);
        if (emails.size() == 0) {
            return null;
        }
        return emails.get(0);
    }

    public static List<String> extractX509CSREmails(PKCS10CertificationRequest certReq) {
        return Crypto.extractX509CSRSANField(certReq, 1);
    }

    public static List<String> extractX509CSRDnsNames(PKCS10CertificationRequest certReq) {
        return Crypto.extractX509CSRSANField(certReq, 2);
    }

    public static List<String> extractX509CSRURIs(PKCS10CertificationRequest certReq) {
        return Crypto.extractX509CSRSANField(certReq, 6);
    }

    public static List<String> extractX509CSRIPAddresses(PKCS10CertificationRequest certReq) {
        Attribute[] attributes;
        ArrayList<String> ipAddresses = new ArrayList<String>();
        for (Attribute attribute : attributes = certReq.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest)) {
            for (ASN1Encodable value : attribute.getAttributeValues()) {
                Extensions extensions = Extensions.getInstance((Object)value);
                GeneralNames gns = GeneralNames.fromExtensions((Extensions)extensions, (ASN1ObjectIdentifier)Extension.subjectAlternativeName);
                if (gns == null) continue;
                for (GeneralName name : gns.getNames()) {
                    if (name.getTagNo() != 7) continue;
                    try {
                        InetAddress addr = InetAddress.getByAddress(((DEROctetString)name.getName()).getOctets());
                        ipAddresses.add(addr.getHostAddress());
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
            }
        }
        return ipAddresses;
    }

    public static String extractX509CSRPublicKey(PKCS10CertificationRequest certReq) {
        PublicKey publicKey;
        JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
        try {
            publicKey = pemConverter.getPublicKey(certReq.getSubjectPublicKeyInfo());
        }
        catch (PEMException ex) {
            LOG.error("extractX509CSRPublicKey: unable to get public key: {}", (Object)ex.getMessage());
            return null;
        }
        return Crypto.convertToPEMFormat(publicKey);
    }

    public static String generateX509CSR(PrivateKey privateKey, String x500Principal, GeneralName[] sanArray) throws OperatorCreationException, IOException {
        PublicKey publicKey = Crypto.extractPublicKey(privateKey);
        if (publicKey == null) {
            throw new CryptoException("Unable to extract public key from private key");
        }
        return Crypto.generateX509CSR(privateKey, publicKey, x500Principal, sanArray);
    }

    public static String generateX509CSR(PrivateKey privateKey, PublicKey publicKey, String x500Principal, GeneralName[] sanArray) throws OperatorCreationException, IOException {
        X500Principal subject = new X500Principal(x500Principal);
        JcaContentSignerBuilder csBuilder = new JcaContentSignerBuilder(RSA_SHA256);
        ContentSigner signer = csBuilder.build(privateKey);
        JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(subject, publicKey);
        if (sanArray != null) {
            ExtensionsGenerator extGen = new ExtensionsGenerator();
            GeneralNames subjectAltNames = new GeneralNames(sanArray);
            extGen.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltNames);
            p10Builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extGen.generate());
        }
        PKCS10CertificationRequest csr = p10Builder.build(signer);
        PemObject pemObject = new PemObject("CERTIFICATE REQUEST", csr.getEncoded());
        StringWriter strWriter = new StringWriter();
        try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)strWriter);){
            pemWriter.writeObject((PemObjectGenerator)pemObject);
        }
        return strWriter.toString();
    }

    public static String extractX509CertSubjectField(X509Certificate x509Cert, ASN1ObjectIdentifier id) {
        String principalName = x509Cert.getSubjectX500Principal().getName();
        if (principalName == null || principalName.isEmpty()) {
            return null;
        }
        X500Name x500name = new X500Name(principalName);
        RDN[] rdns = x500name.getRDNs(id);
        if (rdns == null || rdns.length == 0) {
            return null;
        }
        if (rdns.length != 1) {
            throw new CryptoException("CSR Subject contains multiple values for the same field.");
        }
        return IETFUtils.valueToString((ASN1Encodable)rdns[0].getFirst().getValue());
    }

    public static long extractX509CertIssueTime(X509Certificate x509Cert) {
        return x509Cert.getNotBefore().getTime() / 1000L;
    }

    public static String extractX509CertCommonName(X509Certificate x509Cert) {
        return Crypto.extractX509CertSubjectField(x509Cert, BCStyle.CN);
    }

    public static String extractX509CertSubjectOUField(X509Certificate x509Cert) {
        return Crypto.extractX509CertSubjectField(x509Cert, BCStyle.OU);
    }

    public static String extractX509CertSubjectOField(X509Certificate x509Cert) {
        return Crypto.extractX509CertSubjectField(x509Cert, BCStyle.O);
    }

    public static boolean isRestrictedCertificate(X509Certificate x509Cert, GlobStringsMatcher globStringsMatcher) {
        if (globStringsMatcher == null) {
            LOG.error("isRestrictedCertificate: Required argument globStringsMatcher is null. Returning true.");
            return true;
        }
        if (x509Cert == null) {
            LOG.error("isRestrictedCertificate: Required argument x509Cert is null. Returning true.");
            return true;
        }
        if (globStringsMatcher.isEmptyPatternsList()) {
            return false;
        }
        String x509Ou = Crypto.extractX509CertSubjectOUField(x509Cert);
        return globStringsMatcher.isMatch(x509Ou);
    }

    private static List<String> extractX509CertSANField(X509Certificate x509Cert, int tagNo) {
        Collection<List<?>> altNames = null;
        try {
            altNames = x509Cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException ex) {
            LOG.error("extractX509IPAddresses: Caught CertificateParsingException when parsing certificate: " + ex.getMessage());
        }
        if (altNames == null) {
            return Collections.emptyList();
        }
        ArrayList<String> values = new ArrayList<String>();
        for (List<?> item : altNames) {
            Integer type = (Integer)item.get(0);
            if (type != tagNo) continue;
            values.add((String)item.get(1));
        }
        return values;
    }

    public static List<String> extractX509CertDnsNames(X509Certificate x509Cert) {
        return Crypto.extractX509CertSANField(x509Cert, 2);
    }

    public static List<String> extractX509CertEmails(X509Certificate x509Cert) {
        return Crypto.extractX509CertSANField(x509Cert, 1);
    }

    public static List<String> extractX509CertIPAddresses(X509Certificate x509Cert) {
        return Crypto.extractX509CertSANField(x509Cert, 7);
    }

    public static List<String> extractX509CertURIs(X509Certificate x509Cert) {
        return Crypto.extractX509CertSANField(x509Cert, 6);
    }

    public static String extractX509CertPublicKey(X509Certificate x509Cert) {
        PublicKey publicKey = x509Cert.getPublicKey();
        if (publicKey == null) {
            LOG.error("extractX509CertPublicKey: unable to get public key");
            return null;
        }
        return Crypto.convertToPEMFormat(publicKey);
    }

    public static X509Certificate generateX509Certificate(PKCS10CertificationRequest certReq, PrivateKey caPrivateKey, X509Certificate caCertificate, int validityTimeout, boolean basicConstraints) {
        return Crypto.generateX509Certificate(certReq, caPrivateKey, X500Name.getInstance((Object)caCertificate.getSubjectX500Principal().getEncoded()), validityTimeout, basicConstraints);
    }

    public static X509Certificate generateX509Certificate(PKCS10CertificationRequest certReq, PrivateKey caPrivateKey, X500Name issuer, int validityTimeout, boolean basicConstraints) {
        X509Certificate cert;
        Date notBefore = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(notBefore);
        cal.add(12, validityTimeout);
        Date notAfter = cal.getTime();
        try {
            JcaPKCS10CertificationRequest jcaPKCS10CertificationRequest = new JcaPKCS10CertificationRequest(certReq);
            PublicKey publicKey = jcaPKCS10CertificationRequest.getPublicKey();
            X509v3CertificateBuilder caBuilder = new JcaX509v3CertificateBuilder(issuer, BigInteger.valueOf(System.currentTimeMillis()), notBefore, notAfter, certReq.getSubject(), publicKey).addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(basicConstraints)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new X509KeyUsage(160)).addExtension(Extension.extendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.id_kp_clientAuth, KeyPurposeId.id_kp_serverAuth}));
            ArrayList<GeneralName> altNames = new ArrayList<GeneralName>();
            Attribute[] certAttributes = jcaPKCS10CertificationRequest.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest);
            if (certAttributes != null && certAttributes.length > 0) {
                for (Attribute attribute : certAttributes) {
                    GeneralName[] names;
                    Extensions extensions = Extensions.getInstance((Object)attribute.getAttrValues().getObjectAt(0));
                    GeneralNames gns = GeneralNames.fromExtensions((Extensions)extensions, (ASN1ObjectIdentifier)Extension.subjectAlternativeName);
                    if (gns == null) continue;
                    for (GeneralName name : names = gns.getNames()) {
                        switch (name.getTagNo()) {
                            case 1: 
                            case 2: 
                            case 6: 
                            case 7: {
                                altNames.add(name);
                            }
                        }
                    }
                }
                if (!altNames.isEmpty()) {
                    caBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(altNames.toArray(new GeneralName[0])));
                }
            }
            String signatureAlgorithm = Crypto.getSignatureAlgorithm(caPrivateKey.getAlgorithm(), SHA256);
            ContentSigner caSigner = new JcaContentSignerBuilder(signatureAlgorithm).setProvider(BC_PROVIDER).build(caPrivateKey);
            JcaX509CertificateConverter converter = new JcaX509CertificateConverter().setProvider(BC_PROVIDER);
            cert = converter.getCertificate(caBuilder.build(caSigner));
        }
        catch (CertificateException ex) {
            LOG.error("generateX509Certificate: Caught CertificateException when generating certificate: " + ex.getMessage());
            throw new CryptoException(ex);
        }
        catch (OperatorCreationException ex) {
            LOG.error("generateX509Certificate: Caught OperatorCreationException when creating JcaContentSignerBuilder: " + ex.getMessage());
            throw new CryptoException(ex);
        }
        catch (InvalidKeyException ex) {
            LOG.error("generateX509Certificate: Caught InvalidKeySpecException, invalid key spec is being used: " + ex.getMessage());
            throw new CryptoException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.error("generateX509Certificate: Caught NoSuchAlgorithmException, check to make sure the algorithm is supported by the provider: " + ex.getMessage());
            throw new CryptoException(ex);
        }
        catch (Exception ex) {
            LOG.error("generateX509Certificate: unable to generate X509 Certificate: {}", (Object)ex.getMessage());
            throw new CryptoException("Unable to generate X509 Certificate");
        }
        return cert;
    }

    public static boolean validatePKCS7Signature(String data, String signature, PublicKey publicKey) {
        try {
            SignerInformationStore signerStore;
            try (ByteArrayInputStream sigIs = new ByteArrayInputStream(Base64.decode((byte[])signature.getBytes(StandardCharsets.UTF_8)));){
                CMSProcessableByteArray content = new CMSProcessableByteArray(data.getBytes(StandardCharsets.UTF_8));
                CMSSignedData signedData = new CMSSignedData((CMSProcessable)content, (InputStream)sigIs);
                signerStore = signedData.getSignerInfos();
            }
            Collection signers = signerStore.getSigners();
            Iterator it = signers.iterator();
            SignerInformationVerifier infoVerifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC_PROVIDER).build(publicKey);
            while (it.hasNext()) {
                SignerInformation signerInfo = (SignerInformation)it.next();
                if (!signerInfo.verify(infoVerifier)) continue;
                return true;
            }
        }
        catch (CMSException ex) {
            LOG.error("validatePKCS7Signature: unable to initialize CMSSignedData object: {}", (Object)ex.getMessage());
            throw new CryptoException(ex);
        }
        catch (OperatorCreationException ex) {
            LOG.error("validatePKCS7Signature: Caught OperatorCreationException when creating JcaSimpleSignerInfoVerifierBuilder: {}", (Object)ex.getMessage());
            throw new CryptoException(ex);
        }
        catch (IOException ex) {
            LOG.error("validatePKCS7Signature: Caught IOException when closing InputStream: {}", (Object)ex.getMessage());
            throw new CryptoException(ex);
        }
        catch (Exception ex) {
            LOG.error("validatePKCS7Signature: unable to validate signature: {}", (Object)ex.getMessage());
            throw new CryptoException(ex.getMessage());
        }
        return false;
    }

    public static String convertToPEMFormat(Object obj) {
        StringWriter writer = new StringWriter();
        try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);){
            pemWriter.writeObject(obj);
            pemWriter.flush();
        }
        catch (IOException ex) {
            LOG.error("convertToPEMFormat: unable to convert object to PEM: {}", (Object)ex.getMessage());
            return null;
        }
        return writer.toString();
    }

    public static void main(String[] args) throws CryptoException {
        if (args.length >= 2) {
            String op = args[0];
            if ("sign".equals(op)) {
                if (args.length == 3) {
                    String sig = Crypto.sign(args[1], Crypto.loadPrivateKey(new File(args[2])));
                    System.out.println(sig);
                    System.exit(0);
                }
            } else if ("verify".equals(op)) {
                if (args.length == 4) {
                    if (Crypto.verify(args[1], Crypto.loadPublicKey(new File(args[2])), args[3])) {
                        System.out.println("Verified.");
                    } else {
                        System.out.println("NOT VERIFIED");
                    }
                    System.exit(0);
                }
            } else if ("public".equals(op)) {
                if (args.length == 2) {
                    String pub = Crypto.encodedFile(new File(args[1]));
                    Crypto.loadPublicKey(Crypto.ybase64DecodeString(pub));
                    System.out.println(pub);
                    System.exit(0);
                }
            } else if ("private".equals(op) && args.length == 2) {
                try {
                    String priv = Crypto.encodedFile(new File(args[1]));
                    Crypto.loadPrivateKey(Crypto.ybase64DecodeString(priv));
                    System.out.println(priv);
                    System.exit(0);
                }
                catch (Exception e) {
                    System.out.println("*** " + e.getMessage());
                    System.exit(1);
                }
            }
        }
        System.out.println("usage: r Crypto private privateKeyFile");
        System.out.println("usage: r Crypto public publicKeyFile");
        System.out.println("usage: r Crypto sign msg privateKeyFile");
        System.out.println("usage: r Crypto verify msg privateKeyFile signature");
        System.exit(1);
    }

    static {
        SecureRandom r;
        LOG = LoggerFactory.getLogger(Crypto.class);
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            r = SecureRandom.getInstance("NativePRNGNonBlocking");
        }
        catch (NoSuchAlgorithmException nsa) {
            r = new SecureRandom();
        }
        RANDOM = r;
        RANDOM.nextBytes(new byte[]{8});
    }
}

