/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.util;

import com.yahoo.athenz.auth.AuthorityConsts;
import com.yahoo.athenz.auth.util.Crypto;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AthenzUtils {
    public static String extractServicePrincipal(X509Certificate x509Cert) {
        String principal = Crypto.extractX509CertCommonName(x509Cert);
        if (principal == null) {
            return null;
        }
        if (principal.contains(":role.") && (principal = AthenzUtils.extractPrincipalFromUri(x509Cert)) == null) {
            principal = AthenzUtils.extractPrincipalFromEmail(x509Cert);
        }
        return principal;
    }

    static String extractPrincipalFromEmail(X509Certificate x509Cert) {
        List<String> emails = Crypto.extractX509CertEmails(x509Cert);
        if (emails.size() != 1) {
            return null;
        }
        String email = emails.get(0);
        int idx = email.indexOf(64);
        if (idx == -1) {
            return null;
        }
        return email.substring(0, idx);
    }

    static String extractPrincipalFromUri(X509Certificate x509Cert) {
        List<String> uris = Crypto.extractX509CertURIs(x509Cert);
        for (String uri : uris) {
            if (!uri.startsWith("athenz://principal/")) continue;
            return uri.substring("athenz://principal/".length());
        }
        return null;
    }

    public static boolean isRoleCertificate(X509Certificate x509Cert) {
        String principal = Crypto.extractX509CertCommonName(x509Cert);
        if (principal == null) {
            return false;
        }
        return principal.contains(":role.");
    }

    public static String extractRoleName(String roleName) {
        int idx = roleName.indexOf(":role.");
        if (idx == -1 || idx == 0 || idx == roleName.length() - ":role.".length()) {
            return null;
        }
        return roleName.substring(idx + ":role.".length());
    }

    public static String extractRoleDomainName(String roleName) {
        int idx = roleName.indexOf(":role.");
        if (idx == -1 || idx == 0 || idx == roleName.length() - ":role.".length()) {
            return null;
        }
        return roleName.substring(0, idx);
    }

    public static String extractPrincipalDomainName(String principalName) {
        int idx = principalName.lastIndexOf(46);
        if (idx == -1 || idx == 0 || idx == principalName.length() - 1) {
            return null;
        }
        return principalName.substring(0, idx);
    }

    public static String extractPrincipalServiceName(String principalName) {
        int idx = principalName.lastIndexOf(46);
        if (idx == -1 || idx == 0 || idx == principalName.length() - 1) {
            return null;
        }
        return principalName.substring(idx + 1);
    }

    public static String[] splitPrincipalName(String name) {
        String principalName = name.toLowerCase();
        int idx = principalName.lastIndexOf(46);
        if (idx == -1 || idx == 0 || idx == principalName.length() - 1) {
            return null;
        }
        return new String[]{principalName.substring(0, idx), principalName.substring(idx + 1)};
    }

    public static String getPrincipalName(String domain, String service) {
        if (domain == null || service == null || domain.isEmpty() || service.isEmpty()) {
            return null;
        }
        return (domain + AuthorityConsts.ATHENZ_PRINCIPAL_DELIMITER + service).toLowerCase();
    }

    private AthenzUtils() {
    }

    public static List<String> splitCommaSeparatedSystemProperty(String property) {
        String propertyListStr = System.getProperty(property, null);
        if (propertyListStr == null) {
            return new ArrayList<String>();
        }
        return Stream.of(propertyListStr.trim().split("\\s*,\\s*")).collect(Collectors.toList());
    }
}

