/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.token.jwts;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Key {
    private static final Map<String, String> EC_CURVE_ALIASES = Key.createCurveAliasMap();
    private String alg;
    private String e;
    private String kid;
    private String kty;
    private String n;
    private String use;
    private String x;
    private String y;
    private String crv;

    public String getAlg() {
        return this.alg;
    }

    public void setAlg(String alg) {
        this.alg = alg;
    }

    public String getE() {
        return this.e;
    }

    public void setE(String e) {
        this.e = e;
    }

    public String getKid() {
        return this.kid;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public String getKty() {
        return this.kty;
    }

    public void setKty(String kty) {
        this.kty = kty;
    }

    public String getN() {
        return this.n;
    }

    public void setN(String n) {
        this.n = n;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public String getCrv() {
        return this.crv;
    }

    public void setCrv(String crv) {
        this.crv = crv;
    }

    public String getY() {
        return this.y;
    }

    public void setY(String y) {
        this.y = y;
    }

    public String getX() {
        return this.x;
    }

    public void setX(String x) {
        this.x = x;
    }

    private static Map<String, String> createCurveAliasMap() {
        HashMap<String, String> curveAliases = new HashMap<String, String>();
        curveAliases.put("prime256v1", "secp256r1");
        curveAliases.put("P-256", "secp256r1");
        curveAliases.put("P-384", "secp384r1");
        curveAliases.put("P-521", "secp521r1");
        return Collections.unmodifiableMap(curveAliases);
    }

    private BigInteger urlString2BigInteger(String base64URL) {
        byte[] bytes = Base64.getUrlDecoder().decode(base64URL.getBytes());
        return new BigInteger(1, bytes);
    }

    public PublicKey getPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidParameterSpecException {
        PublicKey publicKey;
        switch (this.kty) {
            case "RSA": {
                RSAPublicKeySpec rsaKeySpec = new RSAPublicKeySpec(this.urlString2BigInteger(this.n), this.urlString2BigInteger(this.e));
                KeyFactory factory = KeyFactory.getInstance("RSA");
                publicKey = factory.generatePublic(rsaKeySpec);
                break;
            }
            case "EC": {
                AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
                parameters.init(new ECGenParameterSpec(EC_CURVE_ALIASES.getOrDefault(this.crv, this.crv)));
                ECParameterSpec ecParameterSpec = parameters.getParameterSpec(ECParameterSpec.class);
                ECPoint ecPoint = new ECPoint(this.urlString2BigInteger(this.x), this.urlString2BigInteger(this.y));
                ECPublicKeySpec ecKeySpec = new ECPublicKeySpec(ecPoint, ecParameterSpec);
                KeyFactory factory = KeyFactory.getInstance("EC");
                publicKey = factory.generatePublic(ecKeySpec);
                break;
            }
            default: {
                throw new NoSuchAlgorithmException(this.kty);
            }
        }
        return publicKey;
    }
}

