/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.token.jwts;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.athenz.auth.token.jwts.JwtsHelper;
import com.yahoo.athenz.auth.token.jwts.Key;
import com.yahoo.athenz.auth.token.jwts.Keys;
import com.yahoo.athenz.auth.util.Crypto;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.SigningKeyResolver;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtsSigningKeyResolver
implements SigningKeyResolver {
    public static final String ZTS_PROP_ATHENZ_CONF = "athenz.athenz_conf";
    private static final String ZTS_DEFAULT_ATHENZ_CONFIG = "/conf/athenz/athenz.conf";
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtsSigningKeyResolver.class);
    private static final ObjectMapper JSON_MAPPER = JwtsSigningKeyResolver.initJsonMapper();
    ConcurrentHashMap<String, PublicKey> publicKeys = new ConcurrentHashMap();

    static ObjectMapper initJsonMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public JwtsSigningKeyResolver(String jwksUri, SSLContext sslContext) {
        this(jwksUri, sslContext, false);
    }

    public JwtsSigningKeyResolver(String jwksUri, SSLContext sslContext, boolean skipConfig) {
        if (!skipConfig) {
            this.loadPublicKeysFromConfig();
        }
        this.loadPublicKeysFromServer(jwksUri, sslContext);
    }

    public java.security.Key resolveSigningKey(JwsHeader jwsHeader, Claims claims) {
        return this.resolveSigningKey(jwsHeader);
    }

    public java.security.Key resolveSigningKey(JwsHeader jwsHeader, String body) {
        return this.resolveSigningKey(jwsHeader);
    }

    private java.security.Key resolveSigningKey(JwsHeader jwsHeader) {
        return this.publicKeys.get(jwsHeader.getKeyId());
    }

    public void addPublicKey(String keyId, PublicKey publicKey) {
        this.publicKeys.put(keyId, publicKey);
    }

    public int publicKeyCount() {
        return this.publicKeys.size();
    }

    void loadPublicKeysFromServer(String jwksUri, SSLContext sslContext) {
        String jwksData = this.getHttpData(jwksUri, sslContext);
        if (jwksData == null) {
            return;
        }
        try {
            Keys keys = (Keys)JSON_MAPPER.readValue(jwksData, Keys.class);
            for (Key key : keys.getKeys()) {
                try {
                    this.publicKeys.put(key.getKid(), key.getPublicKey());
                }
                catch (Exception ex) {
                    LOGGER.error("Unable to generate json web key for key-id {}", (Object)key.getKid());
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Unable to extract json web keys from {}", (Object)jwksUri, (Object)ex);
        }
    }

    String getHttpData(String jwksUri, SSLContext sslContext) {
        JwtsHelper jwtsHelper = new JwtsHelper();
        return jwtsHelper.getHttpData(jwksUri, sslContext);
    }

    void loadPublicKeysFromConfig() {
        String confFileName;
        String rootDir = System.getenv("ROOT");
        if (rootDir == null) {
            rootDir = "/home/athenz";
        }
        if ((confFileName = System.getProperty(ZTS_PROP_ATHENZ_CONF, rootDir + ZTS_DEFAULT_ATHENZ_CONFIG)).isEmpty()) {
            LOGGER.info("No conf file configured for json web keys");
            return;
        }
        Path path = Paths.get(confFileName, new String[0]);
        try {
            AthenzConfig conf = (AthenzConfig)JSON_MAPPER.readValue(Files.readAllBytes(path), AthenzConfig.class);
            ArrayList<ZTSPublicKey> ztsPublicKeys = conf.getZtsPublicKeys();
            if (ztsPublicKeys == null) {
                LOGGER.error("Conf file {} has no json web keys", (Object)confFileName);
                return;
            }
            for (ZTSPublicKey publicKey : ztsPublicKeys) {
                String id = publicKey.getId();
                String key = publicKey.getKey();
                if (key == null || id == null) {
                    LOGGER.error("Missing required zts public key attributes: {}/{}", (Object)id, (Object)key);
                    continue;
                }
                this.publicKeys.put(id, Crypto.loadPublicKey(Crypto.ybase64DecodeString(key)));
            }
            if (this.publicKeys.size() == 0) {
                LOGGER.error("No valid public json web keys in conf file: {}", (Object)confFileName);
            }
        }
        catch (IOException ex) {
            LOGGER.error("Unable to parse conf file {}, error: {}", (Object)confFileName, (Object)ex.getMessage());
        }
    }

    static class AthenzConfig {
        private ArrayList<ZTSPublicKey> ztsPublicKeys;

        AthenzConfig() {
        }

        public ArrayList<ZTSPublicKey> getZtsPublicKeys() {
            return this.ztsPublicKeys;
        }

        public void setZtsPublicKeys(ArrayList<ZTSPublicKey> ztsPublicKeys) {
            this.ztsPublicKeys = ztsPublicKeys;
        }
    }

    static class ZTSPublicKey {
        private String id;
        private String key;

        ZTSPublicKey() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }
    }
}

