/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.token.jwts;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.athenz.auth.token.jwts.OpenIdConfiguration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtsHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtsHelper.class);
    private static final ObjectMapper JSON_MAPPER = JwtsHelper.initJsonMapper();

    static ObjectMapper initJsonMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public String extractJwksUri(String openIdConfigUri, SSLContext sslContext) {
        String opendIdConfigData = this.getHttpData(openIdConfigUri, sslContext);
        if (opendIdConfigData == null) {
            return null;
        }
        try {
            OpenIdConfiguration openIdConfig = (OpenIdConfiguration)JSON_MAPPER.readValue(opendIdConfigData, OpenIdConfiguration.class);
            return openIdConfig.getJwksUri();
        }
        catch (Exception ex) {
            LOGGER.error("Unable to extract jwks uri", (Throwable)ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getHttpData(String serverUri, SSLContext sslContext) {
        if (serverUri == null) return null;
        if (serverUri.isEmpty()) {
            return null;
        }
        try {
            HttpURLConnection httpCon;
            URLConnection con = this.getUrlConnection(serverUri);
            con.setRequestProperty("Accept", "application/json");
            con.setReadTimeout(15000);
            con.setDoOutput(true);
            if (con instanceof HttpURLConnection) {
                httpCon = (HttpURLConnection)con;
                httpCon.setRequestMethod("GET");
            }
            if (con instanceof HttpsURLConnection) {
                HttpsURLConnection httpsCon = (HttpsURLConnection)con;
                SSLSocketFactory sslSocketFactory = this.getSocketFactory(sslContext);
                if (sslSocketFactory != null) {
                    httpsCon.setSSLSocketFactory(sslSocketFactory);
                }
            }
            con.connect();
            if (con instanceof HttpURLConnection && (httpCon = (HttpURLConnection)con).getResponseCode() != 200) {
                LOGGER.error("Unable to extract document from {} error: {}", (Object)serverUri, (Object)httpCon.getResponseCode());
                return null;
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    line = br.readLine();
                }
                String string = sb.toString();
                return string;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Unable to extract document from {} error: {}", (Object)serverUri, (Object)ex.getMessage());
            return null;
        }
    }

    SSLSocketFactory getSocketFactory(SSLContext sslContext) {
        return sslContext == null ? null : sslContext.getSocketFactory();
    }

    URLConnection getUrlConnection(String serverUrl) throws IOException {
        return new URL(serverUrl).openConnection();
    }
}

