/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.token;

import com.yahoo.athenz.auth.util.Crypto;
import com.yahoo.athenz.auth.util.CryptoException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Token {
    private static final Logger LOG = LoggerFactory.getLogger(Token.class);
    protected final int defaultBuilderBufSize = 512;
    protected String unsignedToken = null;
    protected String signedToken = null;
    protected String version = null;
    protected String salt = null;
    protected String host = null;
    protected String ip = null;
    protected String domain = null;
    protected String signature = null;
    protected String keyId = "0";
    protected long expiryTime = 0L;
    protected long timestamp = 0L;
    protected String digestAlgorithm = "SHA256";
    private static final String ATHENZ_PROP_TOKEN_MAX_EXPIRY = "athenz.token_max_expiry";
    private static final long ATHENZ_TOKEN_MAX_EXPIRY = Long.parseLong(System.getProperty("athenz.token_max_expiry", Long.toString(TimeUnit.SECONDS.convert(30L, TimeUnit.DAYS))));
    private static final String ATHENZ_PROP_TOKEN_NO_EXPIRY = "athenz.token_no_expiry";
    static Boolean ATHENZ_TOKEN_NO_EXPIRY = Boolean.parseBoolean(System.getProperty("athenz.token_no_expiry", "false"));

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void sign(String privKey) throws CryptoException {
        this.sign(Crypto.loadPrivateKey(privKey));
    }

    public void sign(PrivateKey key) throws CryptoException {
        this.signature = Crypto.sign(this.unsignedToken, key, this.getDigestAlgorithm());
        this.signedToken = this.unsignedToken + ";s=" + this.signature;
    }

    public void setTimeStamp(long issueTime, long expirationWindow) {
        this.timestamp = issueTime > 0L ? issueTime : System.currentTimeMillis() / 1000L;
        this.expiryTime = this.timestamp + expirationWindow;
    }

    public boolean validate(String pubKey, int allowedOffset) {
        return this.validate(pubKey, allowedOffset, false, null);
    }

    public boolean validate(String pubKey, int allowedOffset, boolean allowNoExpiry) {
        return this.validate(pubKey, allowedOffset, allowNoExpiry, null);
    }

    public boolean validate(String pubKey, int allowedOffset, boolean allowNoExpiry, StringBuilder errMsg) {
        PublicKey publicKey;
        StringBuilder stringBuilder = errMsg = errMsg == null ? new StringBuilder(512) : errMsg;
        if (pubKey == null) {
            errMsg.append("Token:validate: token=").append(this.unsignedToken).append(" : No public key provided");
            LOG.error(errMsg.toString());
            return false;
        }
        try {
            publicKey = Crypto.loadPublicKey(pubKey);
        }
        catch (Exception e) {
            errMsg.append("Token:validate: token=").append(this.unsignedToken).append(" : unable to load public key due to Exception=").append(e.getMessage());
            LOG.error(errMsg.toString());
            return false;
        }
        return this.validate(publicKey, allowedOffset, allowNoExpiry, errMsg);
    }

    public boolean validate(PublicKey publicKey, int allowedOffset, boolean allowNoExpiry, StringBuilder errMsg) {
        StringBuilder stringBuilder = errMsg = errMsg == null ? new StringBuilder(512) : errMsg;
        if (this.unsignedToken == null || this.signature == null) {
            errMsg.append("Token:validate: token=").append(this.unsignedToken).append(" : missing data/signature component");
            LOG.error(errMsg.toString());
            return false;
        }
        if (publicKey == null) {
            errMsg.append("Token:validate: token=").append(this.unsignedToken).append(" : No public key provided");
            LOG.error(errMsg.toString());
            return false;
        }
        long now = System.currentTimeMillis() / 1000L;
        if (this.timestamp != 0L && this.timestamp - (long)allowedOffset > now) {
            errMsg.append("Token:validate: token=").append(this.unsignedToken).append(" : has future timestamp=").append(this.timestamp).append(" : current time=").append(now).append(" : allowed offset=").append(allowedOffset);
            LOG.error(errMsg.toString());
            return false;
        }
        if (this.expiryTime != 0L || !ATHENZ_TOKEN_NO_EXPIRY.booleanValue() || !allowNoExpiry) {
            if (this.expiryTime < now) {
                errMsg.append("Token:validate: token=").append(this.unsignedToken).append(" : has expired time=").append(this.expiryTime).append(" : current time=").append(now);
                LOG.error(errMsg.toString());
                return false;
            }
            if (this.expiryTime > now + ATHENZ_TOKEN_MAX_EXPIRY + (long)allowedOffset) {
                errMsg.append("Token:validate: token=").append(this.unsignedToken).append(" : expires too far in the future=").append(this.expiryTime).append(" : current time=").append(now).append(" : max expiry=").append(ATHENZ_TOKEN_MAX_EXPIRY).append(" : allowed offset=").append(allowedOffset);
                LOG.error(errMsg.toString());
                return false;
            }
        }
        boolean verified = false;
        try {
            verified = Crypto.verify(this.unsignedToken, publicKey, this.signature, this.getDigestAlgorithm());
            if (!verified) {
                errMsg.append("Token:validate: token=").append(this.unsignedToken).append(" : authentication failed");
                LOG.error(errMsg.toString());
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("validate: Token successfully authenticated");
            }
        }
        catch (Exception e) {
            errMsg.append("Token:validate: token=").append(this.unsignedToken).append(" : verify signature failed due to Exception=").append(e.getMessage());
            LOG.error(errMsg.toString());
        }
        return verified;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSalt() {
        return this.salt;
    }

    public String getHost() {
        return this.host;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getSignature() {
        return this.signature;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public String getSignedToken() {
        return this.signedToken;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getIP() {
        return this.ip;
    }

    public String getUnsignedToken() {
        return this.unsignedToken;
    }

    public static String getUnsignedToken(String credential) {
        int idx = credential.indexOf(";s=");
        if (idx != -1) {
            credential = credential.substring(0, idx);
        }
        return credential;
    }
}

