/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.token;

import com.yahoo.athenz.auth.token.Token;
import com.yahoo.athenz.auth.util.Crypto;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleToken
extends Token {
    protected List<String> roles;
    private String principal = null;
    private String proxyUser = null;
    private boolean domainCompleteRoleSet = false;
    private static final Logger LOG = LoggerFactory.getLogger(RoleToken.class);

    private RoleToken(Builder builder) {
        this.version = builder.version;
        this.domain = builder.domain;
        this.roles = builder.roles;
        this.host = builder.host;
        this.salt = builder.salt;
        this.keyId = builder.keyId;
        this.ip = builder.ip;
        this.principal = builder.principal;
        this.proxyUser = builder.proxyUser;
        this.domainCompleteRoleSet = builder.domainCompleteRoleSet;
        super.setTimeStamp(builder.issueTime, builder.expirationWindow);
        StringBuilder strBuilder = new StringBuilder(512);
        strBuilder.append("v=");
        strBuilder.append(this.version);
        strBuilder.append(";d=");
        strBuilder.append(this.domain);
        strBuilder.append(";r=");
        int i = 0;
        for (String role : this.roles) {
            strBuilder.append(role);
            if (++i == this.roles.size()) continue;
            strBuilder.append(",");
        }
        if (this.domainCompleteRoleSet) {
            strBuilder.append(";c=1");
        }
        if (this.principal != null && !this.principal.isEmpty()) {
            strBuilder.append(";p=");
            strBuilder.append(this.principal);
        }
        if (this.host != null && !this.host.isEmpty()) {
            strBuilder.append(";h=");
            strBuilder.append(this.host);
        }
        if (this.proxyUser != null && !this.proxyUser.isEmpty()) {
            strBuilder.append(";proxy=");
            strBuilder.append(this.proxyUser);
        }
        strBuilder.append(";a=");
        strBuilder.append(this.salt);
        strBuilder.append(";t=");
        strBuilder.append(this.timestamp);
        strBuilder.append(";e=");
        strBuilder.append(this.expiryTime);
        strBuilder.append(";k=");
        strBuilder.append(this.keyId);
        if (this.ip != null && !this.ip.isEmpty()) {
            strBuilder.append(";i=");
            strBuilder.append(this.ip);
        }
        this.unsignedToken = strBuilder.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("RoleToken created: {}", (Object)this.unsignedToken);
        }
    }

    public RoleToken(String signedToken) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Constructing RoleToken with input string: {}", (Object)signedToken);
        }
        if (signedToken == null || signedToken.isEmpty()) {
            throw new IllegalArgumentException("Input String signedToken must not be empty");
        }
        int idx = signedToken.indexOf(";s=");
        if (idx != -1) {
            this.unsignedToken = signedToken.substring(0, idx);
            this.signature = signedToken.substring(idx + 3);
        }
        String parseToken = this.unsignedToken != null ? this.unsignedToken : signedToken;
        String roleNames = null;
        block28: for (String item : parseToken.split(";")) {
            String[] kv = item.split("=");
            if (kv.length != 2) continue;
            switch (kv[0]) {
                case "a": {
                    this.salt = kv[1];
                    continue block28;
                }
                case "c": {
                    if (Integer.parseInt(kv[1]) != 1) continue block28;
                    this.domainCompleteRoleSet = true;
                    continue block28;
                }
                case "d": {
                    this.domain = kv[1];
                    continue block28;
                }
                case "e": {
                    this.expiryTime = Long.parseLong(kv[1]);
                    continue block28;
                }
                case "h": {
                    this.host = kv[1];
                    continue block28;
                }
                case "i": {
                    this.ip = kv[1];
                    continue block28;
                }
                case "k": {
                    this.keyId = kv[1];
                    continue block28;
                }
                case "p": {
                    this.principal = kv[1];
                    continue block28;
                }
                case "r": {
                    roleNames = kv[1];
                    continue block28;
                }
                case "t": {
                    this.timestamp = Long.parseLong(kv[1]);
                    continue block28;
                }
                case "proxy": {
                    this.proxyUser = kv[1];
                    continue block28;
                }
                case "v": {
                    this.version = kv[1];
                }
            }
        }
        if (this.domain == null || this.domain.isEmpty()) {
            throw new IllegalArgumentException("SignedToken does not contain required domain component");
        }
        if (roleNames == null || roleNames.isEmpty()) {
            throw new IllegalArgumentException("SignedToken does not contain required roles component");
        }
        this.roles = Arrays.asList(roleNames.split(","));
        this.signedToken = signedToken;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Values extracted from token version:{} domain:{} roles:{} principal:{} host:{} salt:{} timestamp:{} expiryTime:{} domainCompleteRoleSet:{} keyId:{} ip:{} proxyUser:{} signature:{}", new Object[]{this.version, this.domain, roleNames, this.principal, this.host, this.salt, this.timestamp, this.expiryTime, this.domainCompleteRoleSet, this.keyId, this.ip, this.proxyUser, this.signature});
        }
    }

    public String getPrincipal() {
        return this.principal;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public boolean getDomainCompleteRoleSet() {
        return this.domainCompleteRoleSet;
    }

    public static class Builder {
        private String domain;
        private List<String> roles;
        private String version;
        private String principal = null;
        private String proxyUser = null;
        private boolean domainCompleteRoleSet = false;
        private String salt = Crypto.randomSalt();
        private String host = null;
        private String ip = null;
        private String keyId = "0";
        private long expirationWindow = 3600L;
        private long issueTime = 0L;

        public Builder(String version, String domain, List<String> roles) {
            if (version == null || domain == null || roles == null) {
                throw new IllegalArgumentException("version, domain and roles parameters must not be null.");
            }
            if (version.isEmpty() || domain.isEmpty() || roles.isEmpty()) {
                throw new IllegalArgumentException("version, domain and roles parameters must have values.");
            }
            this.version = version;
            this.domain = domain;
            this.roles = roles;
        }

        public Builder principal(String value) {
            this.principal = value;
            return this;
        }

        public Builder host(String value) {
            this.host = value;
            return this;
        }

        public Builder salt(String value) {
            this.salt = value;
            return this;
        }

        public Builder ip(String value) {
            this.ip = value;
            return this;
        }

        public Builder keyId(String value) {
            this.keyId = value;
            return this;
        }

        public Builder proxyUser(String value) {
            this.proxyUser = value;
            return this;
        }

        public Builder issueTime(long value) {
            this.issueTime = value;
            return this;
        }

        public Builder expirationWindow(long value) {
            this.expirationWindow = value;
            return this;
        }

        public Builder domainCompleteRoleSet(boolean value) {
            this.domainCompleteRoleSet = value;
            return this;
        }

        public RoleToken build() {
            return new RoleToken(this);
        }
    }
}

