/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.token;

import com.yahoo.athenz.auth.token.Token;
import com.yahoo.athenz.auth.util.Crypto;
import com.yahoo.athenz.auth.util.CryptoException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalToken
extends Token {
    private String name = null;
    private String originalRequestor = null;
    protected String keyService = null;
    private List<String> authorizedServices = null;
    private String authorizedServiceName = null;
    private String authorizedServiceKeyId = "0";
    private String authorizedServiceSignature = null;
    private static final Logger LOG = LoggerFactory.getLogger(PrincipalToken.class);

    private PrincipalToken(Builder builder) {
        this.version = builder.version;
        this.domain = builder.domain;
        this.name = builder.name;
        this.host = builder.host;
        this.salt = builder.salt;
        this.keyId = builder.keyId;
        this.ip = builder.ip;
        this.authorizedServices = builder.authorizedServices;
        this.keyService = builder.keyService;
        this.originalRequestor = builder.originalRequestor;
        super.setTimeStamp(builder.issueTime, builder.expirationWindow);
        StringBuilder strBuilder = new StringBuilder(512);
        strBuilder.append("v=");
        strBuilder.append(this.version);
        strBuilder.append(";d=");
        strBuilder.append(this.domain);
        strBuilder.append(";n=");
        strBuilder.append(this.name);
        if (this.host != null && !this.host.isEmpty()) {
            strBuilder.append(";h=");
            strBuilder.append(this.host);
        }
        strBuilder.append(";a=");
        strBuilder.append(this.salt);
        strBuilder.append(";t=");
        strBuilder.append(this.timestamp);
        strBuilder.append(";e=");
        strBuilder.append(this.expiryTime);
        strBuilder.append(";k=");
        strBuilder.append(this.keyId);
        if (this.keyService != null && !this.keyService.isEmpty()) {
            strBuilder.append(";z=");
            strBuilder.append(this.keyService);
        }
        if (this.originalRequestor != null && !this.originalRequestor.isEmpty()) {
            strBuilder.append(";o=");
            strBuilder.append(this.originalRequestor);
        }
        if (this.ip != null && !this.ip.isEmpty()) {
            strBuilder.append(";i=");
            strBuilder.append(this.ip);
        }
        if (this.authorizedServices != null && !this.authorizedServices.isEmpty()) {
            strBuilder.append(";b=");
            strBuilder.append(String.join((CharSequence)",", this.authorizedServices));
        }
        this.unsignedToken = strBuilder.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("PrincipalToken created: {}", (Object)this.unsignedToken);
        }
    }

    public PrincipalToken(String signedToken) {
        String[] kv;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Constructing PrincipalToken with input string: {}", (Object)signedToken);
        }
        if (signedToken == null || signedToken.isEmpty()) {
            throw new IllegalArgumentException("Input String signedToken must not be empty");
        }
        String authzSvcToken = null;
        int idx = signedToken.indexOf(";s=");
        if (idx != -1) {
            this.unsignedToken = signedToken.substring(0, idx);
            int authzIdx = signedToken.indexOf(59, idx + 3);
            if (authzIdx != -1 && signedToken.indexOf(";bs=", idx + 3) != -1) {
                this.signature = signedToken.substring(idx + 3, authzIdx);
                authzSvcToken = signedToken.substring(authzIdx);
            } else {
                this.signature = signedToken.substring(idx + 3);
            }
        }
        String parseToken = this.unsignedToken != null ? this.unsignedToken : signedToken;
        block36: for (String item : parseToken.split(";")) {
            kv = item.split("=");
            if (kv.length != 2) continue;
            switch (kv[0]) {
                case "a": {
                    this.salt = kv[1];
                    continue block36;
                }
                case "b": {
                    this.authorizedServices = Arrays.asList(kv[1].split(","));
                    continue block36;
                }
                case "d": {
                    this.domain = kv[1];
                    continue block36;
                }
                case "e": {
                    this.expiryTime = Long.parseLong(kv[1]);
                    continue block36;
                }
                case "h": {
                    this.host = kv[1];
                    continue block36;
                }
                case "i": {
                    this.ip = kv[1];
                    continue block36;
                }
                case "k": {
                    this.keyId = kv[1];
                    continue block36;
                }
                case "n": {
                    this.name = kv[1];
                    continue block36;
                }
                case "o": {
                    this.originalRequestor = kv[1];
                    continue block36;
                }
                case "t": {
                    this.timestamp = Long.parseLong(kv[1]);
                    continue block36;
                }
                case "v": {
                    this.version = kv[1];
                    continue block36;
                }
                case "z": {
                    this.keyService = kv[1];
                }
            }
        }
        if (authzSvcToken != null && !authzSvcToken.isEmpty() && (idx = authzSvcToken.indexOf(";bs=")) != -1) {
            this.authorizedServiceSignature = authzSvcToken.substring(idx + 4);
            block37: for (String item : authzSvcToken.substring(0, idx).split(";")) {
                kv = item.split("=");
                if (kv.length != 2) continue;
                switch (kv[0]) {
                    case "bk": {
                        this.authorizedServiceKeyId = kv[1];
                        continue block37;
                    }
                    case "bn": {
                        this.authorizedServiceName = kv[1];
                    }
                }
            }
        }
        if (this.domain == null || this.domain.isEmpty()) {
            throw new IllegalArgumentException("SignedToken does not contain required domain component");
        }
        if (this.name == null || this.name.isEmpty()) {
            throw new IllegalArgumentException("SignedToken does not contain required name component");
        }
        this.signedToken = signedToken;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Values extracted from token version:{} domain:{} service:{} host:{} ip:{} id:{} keyService:{} originalRequestor:{} salt:{} timestamp:{} expiryTime:{} signature:{}", new Object[]{this.version, this.domain, this.name, this.host, this.ip, this.keyId, this.keyService, this.originalRequestor, this.salt, this.timestamp, this.expiryTime, this.signature});
            if (this.authorizedServices != null) {
                LOG.debug("Authorized service details from token authorizedServices:{} authorizedServiceName:{} authorizedServiceKeyId:{} authorizedServiceSignature:{}", new Object[]{String.join((CharSequence)",", this.authorizedServices), this.authorizedServiceName, this.authorizedServiceKeyId, this.authorizedServiceSignature});
            }
        }
    }

    public void signForAuthorizedService(String authorizedServiceName, String authorizedServiceKeyId, String privKey) throws CryptoException {
        this.signForAuthorizedService(authorizedServiceName, authorizedServiceKeyId, Crypto.loadPrivateKey(privKey));
    }

    public void signForAuthorizedService(String authorizedServiceName, String authorizedServiceKeyId, PrivateKey key) throws CryptoException {
        if (this.authorizedServices == null || !this.authorizedServices.contains(authorizedServiceName)) {
            throw new IllegalArgumentException("Authorized Service is not valid for this token");
        }
        this.authorizedServiceKeyId = authorizedServiceKeyId;
        StringBuilder tokenToSign = new StringBuilder(512);
        tokenToSign.append(this.signedToken);
        tokenToSign.append(";bk=");
        tokenToSign.append(authorizedServiceKeyId);
        if (this.authorizedServices.size() > 1) {
            this.authorizedServiceName = authorizedServiceName;
            tokenToSign.append(";bn=");
            tokenToSign.append(authorizedServiceName);
        }
        this.authorizedServiceSignature = Crypto.sign(tokenToSign.toString(), key);
        tokenToSign.append(";bs=");
        tokenToSign.append(this.authorizedServiceSignature);
        this.signedToken = tokenToSign.toString();
    }

    public boolean validateForAuthorizedService(String pubKey, StringBuilder errMsg) {
        StringBuilder stringBuilder = errMsg = errMsg == null ? new StringBuilder(512) : errMsg;
        if (this.authorizedServiceSignature == null) {
            errMsg.append("PrincipalToken:validateForAuthorizedService: token=").append(this.unsignedToken).append(" : missing data/signature component: public key=").append(pubKey);
            LOG.error(errMsg.toString());
            return false;
        }
        int idx = this.signedToken.indexOf(";bs=");
        if (idx == -1) {
            errMsg.append("PrincipalToken:validateForAuthorizedService: token=").append(this.unsignedToken).append(" : not signed by any authorized service");
            LOG.error(errMsg.toString());
            return false;
        }
        String unsignedAuthorizedServiceToken = this.signedToken.substring(0, idx);
        if (pubKey == null) {
            errMsg.append("PrincipalToken:validateForAuthorizedService: token=").append(this.unsignedToken).append(" : No public key provided");
            LOG.error(errMsg.toString());
            return false;
        }
        boolean verified = false;
        try {
            PublicKey pub = Crypto.loadPublicKey(pubKey);
            verified = Crypto.verify(unsignedAuthorizedServiceToken, pub, this.authorizedServiceSignature);
            if (!verified) {
                errMsg.append("PrincipalToken:validateForAuthorizedService: token=").append(this.unsignedToken).append(" : authentication failed: public key=").append(pubKey);
                LOG.error(errMsg.toString());
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("validateForAuthorizedService: Token: {} -  successfully authenticated", (Object)this.unsignedToken);
            }
        }
        catch (Exception e) {
            errMsg.append("PrincipalToken:validateForAuthorizedService: token=").append(this.unsignedToken).append(" : authentication failed verifying signature: exc=").append(e.getMessage()).append(" : public key=").append(pubKey);
            LOG.error(errMsg.toString());
        }
        return verified;
    }

    public boolean isValidAuthorizedServiceToken(StringBuilder errMsg) {
        StringBuilder stringBuilder = errMsg = errMsg == null ? new StringBuilder(512) : errMsg;
        if (this.authorizedServices == null) {
            if (this.authorizedServiceSignature == null) {
                return true;
            }
            errMsg.append("PrincipalToken:isValidAuthorizedServiceToken: Invalid Token=").append(this.unsignedToken).append(" : Authorized Service Signature available without service name");
            LOG.error(errMsg.toString());
            return false;
        }
        if (this.authorizedServiceSignature == null) {
            errMsg.append("PrincipalToken:isValidAuthorizedServiceToken: Invalid Token=").append(this.unsignedToken).append(" : Missing signature for specified authorized service");
            LOG.error(errMsg.toString());
            return false;
        }
        if (this.authorizedServiceName != null) {
            if (!this.authorizedServices.contains(this.authorizedServiceName)) {
                errMsg.append("PrincipalToken:isValidAuthorizedServiceToken: Invalid Token=").append(this.unsignedToken).append(" : Authorized service name=").append(this.authorizedServiceName).append(" is not listed in the service list");
                LOG.error(errMsg.toString());
                return false;
            }
        } else if (this.authorizedServices.size() != 1) {
            errMsg.append("PrincipalToken:isValidAuthorizedServiceToken: Invalid Token=").append(this.unsignedToken).append(" : No service name and Authorized service list contains multiple entries");
            LOG.error(errMsg.toString());
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String getKeyService() {
        return this.keyService;
    }

    public String getOriginalRequestor() {
        return this.originalRequestor;
    }

    public List<String> getAuthorizedServices() {
        return this.authorizedServices;
    }

    public String getAuthorizedServiceName() {
        return this.authorizedServiceName;
    }

    public String getAuthorizedServiceKeyId() {
        return this.authorizedServiceKeyId;
    }

    public String getAuthorizedServiceSignature() {
        return this.authorizedServiceSignature;
    }

    public static class Builder {
        private String domain;
        private String name;
        private String version;
        private String salt = Crypto.randomSalt();
        private String host = null;
        private String ip = null;
        private String keyId = "0";
        private long expirationWindow = 3600L;
        private long issueTime = 0L;
        private List<String> authorizedServices = null;
        private String keyService = null;
        private String originalRequestor = null;

        public Builder(String version, String domain, String name) {
            if (version == null || domain == null || name == null) {
                throw new IllegalArgumentException("version, domain and name parameters must not be null.");
            }
            if (version.isEmpty() || domain.isEmpty() || name.isEmpty()) {
                throw new IllegalArgumentException("version, domain and name parameters must have values.");
            }
            this.version = version;
            this.domain = domain;
            this.name = name;
        }

        public Builder host(String value) {
            this.host = value;
            return this;
        }

        public Builder salt(String value) {
            this.salt = value;
            return this;
        }

        public Builder ip(String value) {
            this.ip = value;
            return this;
        }

        public Builder keyId(String value) {
            this.keyId = value;
            return this;
        }

        public Builder issueTime(long value) {
            this.issueTime = value;
            return this;
        }

        public Builder expirationWindow(long value) {
            this.expirationWindow = value;
            return this;
        }

        public Builder authorizedServices(List<String> authorizedServices) {
            this.authorizedServices = authorizedServices;
            return this;
        }

        public Builder keyService(String value) {
            this.keyService = value;
            return this;
        }

        public Builder originalRequestor(String value) {
            this.originalRequestor = value;
            return this;
        }

        public PrincipalToken build() {
            return new PrincipalToken(this);
        }
    }
}

