/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.token;

import com.yahoo.athenz.auth.token.jwts.JwtsSigningKeyResolver;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolver;
import java.security.Key;
import java.security.PublicKey;
import java.util.Date;

public class OAuth2Token {
    public static final String HDR_KEY_ID = "kid";
    public static final String CLAIM_VERSION = "ver";
    public static final String CLAIM_AUTH_TIME = "auth_time";
    protected int version;
    protected long expiryTime;
    protected long issueTime;
    protected long authTime;
    protected long notBeforeTime;
    protected String audience;
    protected String issuer;
    protected String subject;
    protected String jwtId;
    protected Jws<Claims> claims = null;

    public OAuth2Token() {
    }

    public OAuth2Token(String token, JwtsSigningKeyResolver keyResolver) {
        this.claims = Jwts.parserBuilder().setSigningKeyResolver((SigningKeyResolver)keyResolver).setAllowedClockSkewSeconds(60L).build().parseClaimsJws(token);
        this.setTokenFields();
    }

    public OAuth2Token(String token, PublicKey publicKey) {
        this.claims = Jwts.parserBuilder().setSigningKey((Key)publicKey).setAllowedClockSkewSeconds(60L).build().parseClaimsJws(token);
        this.setTokenFields();
    }

    int parseIntegerValue(Claims body, String claimName) {
        try {
            return (Integer)body.get(claimName, Integer.class);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    long parseLongValue(Claims body, String claimName) {
        try {
            return (Long)body.get(claimName, Long.class);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    long parseDateValue(Date date) {
        return date == null ? 0L : date.getTime() / 1000L;
    }

    void setTokenFields() {
        Claims body = (Claims)this.claims.getBody();
        this.setVersion(this.parseIntegerValue(body, CLAIM_VERSION));
        this.setAudience(body.getAudience());
        this.setExpiryTime(this.parseDateValue(body.getExpiration()));
        this.setIssueTime(this.parseDateValue(body.getIssuedAt()));
        this.setNotBeforeTime(this.parseDateValue(body.getNotBefore()));
        this.setAuthTime(this.parseLongValue(body, CLAIM_AUTH_TIME));
        this.setIssuer(body.getIssuer());
        this.setSubject(body.getSubject());
        this.setJwtId(body.getId());
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(long expiryTime) {
        this.expiryTime = expiryTime;
    }

    public long getIssueTime() {
        return this.issueTime;
    }

    public void setIssueTime(long issueTime) {
        this.issueTime = issueTime;
    }

    public long getNotBeforeTime() {
        return this.notBeforeTime;
    }

    public void setNotBeforeTime(long notBeforeTime) {
        this.notBeforeTime = notBeforeTime;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public long getAuthTime() {
        return this.authTime;
    }

    public void setAuthTime(long authTime) {
        this.authTime = authTime;
    }

    public String getJwtId() {
        return this.jwtId;
    }

    public void setJwtId(String jwtId) {
        this.jwtId = jwtId;
    }
}

