/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.token;

import com.yahoo.athenz.auth.token.Token;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.bouncycastle.util.encoders.Base64;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosToken
extends Token {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosToken.class);
    public static final String KRB_AUTH_VAL_FLD = "Negotiate";
    public static final String KRB_PROP_TOKEN_PRIV_ACTION = "athenz.auth.kerberos.krb_privileged_action_class";
    private static final String ATHENZ_PROP_USER_DOMAIN = "athenz.user_domain";
    private static final String ATHENZ_PROP_USER_REALM = "athenz.auth.kerberos.user_realm";
    private static final String ATHENZ_PROP_KRB_USER_DOMAIN = "athenz.auth.kerberos.krb_user_domain";
    private static final String ATHENZ_PROP_KRB_USER_REALM = "athenz.auth.kerberos.krb_user_realm";
    private String krbPrivActionClass = System.getProperty("athenz.auth.kerberos.krb_privileged_action_class");
    private String userName = null;
    public static final String USER_DOMAIN = System.getProperty("athenz.user_domain", "user");
    private static final String USER_REALM = System.getProperty("athenz.auth.kerberos.user_realm", "USER_REALM");
    public static final String KRB_USER_DOMAIN = System.getProperty("athenz.auth.kerberos.krb_user_domain", "krb");
    public static final String KRB_USER_REALM = System.getProperty("athenz.auth.kerberos.krb_user_realm", "KRB_REALM");

    public KerberosToken(String creds, String remoteAddr) {
        if (creds == null || creds.isEmpty()) {
            LOG.error("KerberosToken: Missing credentials");
            throw new IllegalArgumentException("KerberosToken: creds must not be empty");
        }
        if (!creds.startsWith(KRB_AUTH_VAL_FLD)) {
            throw new IllegalArgumentException("KerberosToken: creds do not contain required Negotiate component");
        }
        this.signedToken = creds;
        this.unsignedToken = creds.substring(KRB_AUTH_VAL_FLD.length()).trim();
        this.domain = KRB_USER_DOMAIN;
    }

    public boolean validate(Subject serviceSubject, StringBuilder errMsg) {
        try {
            PrivilegedExceptionAction<String> privExcAction;
            byte[] kerberosTicket = Base64.decode((byte[])this.unsignedToken.getBytes(StandardCharsets.UTF_8));
            if (this.krbPrivActionClass == null) {
                privExcAction = new KerberosValidateAction(kerberosTicket);
            } else {
                Class<?> privActionClass = Class.forName(this.krbPrivActionClass);
                privExcAction = (PrivilegedExceptionAction)privActionClass.getConstructor(byte[].class).newInstance(new Object[]{kerberosTicket});
            }
            this.userName = Subject.doAs(serviceSubject, privExcAction);
            int index = this.userName.indexOf(64);
            if (index != -1) {
                if (this.userName.indexOf(KRB_USER_REALM, index) == -1) {
                    if (this.userName.indexOf(USER_REALM, index) != -1) {
                        this.domain = USER_DOMAIN;
                    } else {
                        throw new Exception("KerberosToken:validate: invalid Kerberos Realm: " + this.userName);
                    }
                }
                this.userName = this.userName.substring(0, index);
            }
            return true;
        }
        catch (PrivilegedActionException paexc) {
            if (errMsg == null) {
                errMsg = new StringBuilder(512);
            }
            errMsg.append("KerberosToken:validate: token=").append(this.unsignedToken).append(" : privilege exc=").append(paexc);
            LOG.error(errMsg.toString());
        }
        catch (Exception exc) {
            if (errMsg == null) {
                errMsg = new StringBuilder(512);
            }
            errMsg.append("KerberosToken:validate: token=").append(this.unsignedToken).append(" : unknown exc=").append(exc);
            LOG.error(errMsg.toString());
        }
        return false;
    }

    public String getUserName() {
        return this.userName;
    }

    private static class KerberosValidateAction
    implements PrivilegedExceptionAction<String> {
        final byte[] kerberosTicket;

        KerberosValidateAction(byte[] kerberosTicket) {
            this.kerberosTicket = kerberosTicket;
        }

        @Override
        public String run() throws Exception {
            GSSContext context = GSSManager.getInstance().createContext((GSSCredential)null);
            context.acceptSecContext(this.kerberosTicket, 0, this.kerberosTicket.length);
            String user = context.getSrcName().toString();
            context.dispose();
            return user;
        }
    }
}

