/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.token;

import com.yahoo.athenz.auth.token.OAuth2Token;
import com.yahoo.athenz.auth.token.jwts.JwtsSigningKeyResolver;
import com.yahoo.athenz.auth.util.Crypto;
import com.yahoo.athenz.auth.util.CryptoException;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Base64;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessToken
extends OAuth2Token {
    public static final String HDR_TOKEN_TYPE = "typ";
    public static final String HDR_TOKEN_JWT = "at+jwt";
    public static final String CLAIM_SCOPE = "scp";
    public static final String CLAIM_SCOPE_STD = "scope";
    public static final String CLAIM_UID = "uid";
    public static final String CLAIM_CLIENT_ID = "client_id";
    public static final String CLAIM_CONFIRM = "cnf";
    public static final String CLAIM_PROXY = "proxy";
    public static final String CLAIM_AUTHZ_DETAILS = "authorization_details";
    public static final String CLAIM_CONFIRM_X509_HASH = "x5t#S256";
    private static final Logger LOG = LoggerFactory.getLogger(AccessToken.class);
    private static long ACCESS_TOKEN_CERT_OFFSET = 3600L;
    private static Set<String> ACCESS_TOKEN_PROXY_PRINCIPALS = null;
    private String clientId;
    private String userId;
    private String proxyPrincipal;
    private String authorizationDetails;
    private String scopeStd;
    private List<String> scope;
    private LinkedHashMap<String, Object> confirm;

    public AccessToken() {
    }

    public AccessToken(String token, JwtsSigningKeyResolver keyResolver) {
        super(token, keyResolver);
        this.setAccessTokenFields();
    }

    public AccessToken(String token, PublicKey publicKey) {
        super(token, publicKey);
        this.setAccessTokenFields();
    }

    public AccessToken(String token, JwtsSigningKeyResolver keyResolver, X509Certificate x509Cert) {
        this(token, keyResolver, x509Cert, null);
    }

    public AccessToken(String token, JwtsSigningKeyResolver keyResolver, X509Certificate x509Cert, String x509CertHash) {
        super(token, keyResolver);
        this.setAccessTokenFields();
        if (!this.confirmMTLSBoundToken(x509Cert, x509CertHash)) {
            LOG.error("AccessToken: X.509 Certificate Confirmation failure");
            throw new CryptoException(2, "X.509 Certificate Confirmation failure");
        }
    }

    public static void setAccessTokenCertOffset(long offset) {
        ACCESS_TOKEN_CERT_OFFSET = offset;
    }

    public static void setAccessTokenProxyPrincipals(Set<String> proxyPrincipals) {
        ACCESS_TOKEN_PROXY_PRINCIPALS = proxyPrincipals;
    }

    void setAccessTokenFields() {
        Claims body = (Claims)this.claims.getBody();
        this.setClientId((String)body.get(CLAIM_CLIENT_ID, String.class));
        this.setUserId((String)body.get(CLAIM_UID, String.class));
        this.setProxyPrincipal((String)body.get(CLAIM_PROXY, String.class));
        this.setScopeStd((String)body.get(CLAIM_SCOPE_STD, String.class));
        this.setScope((List)body.get(CLAIM_SCOPE, List.class));
        this.setConfirm((LinkedHashMap)body.get(CLAIM_CONFIRM, LinkedHashMap.class));
        this.setAuthorizationDetails((String)body.get(CLAIM_AUTHZ_DETAILS, String.class));
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getProxyPrincipal() {
        return this.proxyPrincipal;
    }

    public void setProxyPrincipal(String proxyPrincipal) {
        this.proxyPrincipal = proxyPrincipal;
    }

    public String getAuthorizationDetails() {
        return this.authorizationDetails;
    }

    public void setAuthorizationDetails(String authorizationDetails) {
        this.authorizationDetails = authorizationDetails;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public List<String> getScope() {
        return this.scope;
    }

    public void setScope(List<String> scope) {
        this.scope = scope;
        if (scope != null && !scope.isEmpty() && this.scopeStd == null) {
            this.scopeStd = String.join((CharSequence)" ", scope);
        }
    }

    public String getScopeStd() {
        return this.scopeStd;
    }

    public void setScopeStd(String scopeStd) {
        this.scopeStd = scopeStd;
    }

    public LinkedHashMap<String, Object> getConfirm() {
        return this.confirm;
    }

    public void setConfirm(LinkedHashMap<String, Object> confirm) {
        this.confirm = confirm;
    }

    public void setConfirmEntry(String key, Object value) {
        if (this.confirm == null) {
            this.confirm = new LinkedHashMap();
        }
        this.confirm.put(key, value);
    }

    public void setConfirmX509CertHash(X509Certificate cert) {
        this.setConfirmEntry(CLAIM_CONFIRM_X509_HASH, this.getX509CertificateHash(cert));
    }

    public boolean confirmMTLSBoundToken(X509Certificate x509Cert, String x509CertHash) {
        if (x509Cert == null) {
            LOG.error("confirmMTLSBoundToken: null certificate");
            return false;
        }
        String cnfHash = (String)this.getConfirmEntry(CLAIM_CONFIRM_X509_HASH);
        if (cnfHash == null) {
            LOG.error("confirmMTLSBoundToken: token does not have confirmation entry");
            return false;
        }
        if (this.confirmX509CertHash(x509Cert, cnfHash)) {
            return true;
        }
        String cn = Crypto.extractX509CertCommonName(x509Cert);
        if (cn == null) {
            LOG.error("confirmMTLSBoundToken: null principal in certificate}");
            return false;
        }
        if (this.confirmX509CertPrincipal(x509Cert, cn)) {
            return true;
        }
        return this.confirmX509ProxyPrincipal(cn, x509CertHash, cnfHash);
    }

    boolean confirmX509CertHash(X509Certificate cert, String cnfHash) {
        String certHash = this.getX509CertificateHash(cert);
        return cnfHash.equals(certHash);
    }

    boolean confirmX509ProxyPrincipal(String cn, String certHash, String cnfHash) {
        if (ACCESS_TOKEN_PROXY_PRINCIPALS != null && !ACCESS_TOKEN_PROXY_PRINCIPALS.contains(cn)) {
            LOG.error("confirmX509ProxyPrincipal: unauthorized proxy principal: {}", (Object)cn);
            return false;
        }
        return cnfHash.equals(certHash);
    }

    boolean confirmX509CertPrincipal(X509Certificate cert, String cn) {
        if (ACCESS_TOKEN_CERT_OFFSET == 0L) {
            LOG.error("confirmX509CertPrincipal: check disabled");
            return false;
        }
        if (!cn.equals(this.clientId)) {
            LOG.error("confirmX509CertPrincipal: Principal mismatch {} vs {}", (Object)cn, (Object)this.clientId);
            return false;
        }
        if (ACCESS_TOKEN_CERT_OFFSET == -1L) {
            return true;
        }
        long certIssueTime = Crypto.extractX509CertIssueTime(cert);
        if (certIssueTime < this.issueTime - 3600L) {
            LOG.error("confirmX509CertPrincipal: Certificate: {} issued before token: {}", (Object)certIssueTime, (Object)this.issueTime);
            return false;
        }
        if (certIssueTime > this.issueTime + ACCESS_TOKEN_CERT_OFFSET - 3600L) {
            LOG.error("confirmX509CertPrincipal: Certificate: {} past configured offset {} for token: {}", new Object[]{certIssueTime, ACCESS_TOKEN_CERT_OFFSET, this.issueTime});
            return false;
        }
        return true;
    }

    String getX509CertificateHash(X509Certificate cert) {
        try {
            byte[] encCert = Crypto.sha256(cert.getEncoded());
            return Base64.getUrlEncoder().withoutPadding().encodeToString(encCert);
        }
        catch (CryptoException | CertificateEncodingException ex) {
            LOG.error("Unable to get X.509 certificate hash", (Throwable)ex);
            return null;
        }
    }

    public Object getConfirmEntry(String key) {
        return this.confirm == null ? null : this.confirm.get(key);
    }

    public String getSignedToken(PrivateKey key, String keyId, SignatureAlgorithm keyAlg) {
        return Jwts.builder().setSubject(this.subject).setId(this.jwtId).setIssuedAt(Date.from(Instant.ofEpochSecond(this.issueTime))).setExpiration(Date.from(Instant.ofEpochSecond(this.expiryTime))).setIssuer(this.issuer).setAudience(this.audience).claim("auth_time", (Object)this.authTime).claim("ver", (Object)this.version).claim(CLAIM_SCOPE, this.scope).claim(CLAIM_SCOPE_STD, (Object)this.scopeStd).claim(CLAIM_UID, (Object)this.userId).claim(CLAIM_CLIENT_ID, (Object)this.clientId).claim(CLAIM_CONFIRM, this.confirm).claim(CLAIM_PROXY, (Object)this.proxyPrincipal).claim(CLAIM_AUTHZ_DETAILS, (Object)this.authorizationDetails).setHeaderParam("kid", (Object)keyId).setHeaderParam(HDR_TOKEN_TYPE, (Object)HDR_TOKEN_JWT).signWith((Key)key, keyAlg).compact();
    }
}

