/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.oauth.validator;

import com.yahoo.athenz.auth.oauth.token.OAuthJwtAccessToken;
import com.yahoo.athenz.auth.oauth.token.OAuthJwtAccessTokenException;
import com.yahoo.athenz.auth.util.Crypto;
import com.yahoo.athenz.auth.util.CryptoException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Base64;

public interface OAuthJwtAccessTokenValidator {
    public void validate(OAuthJwtAccessToken var1) throws OAuthJwtAccessTokenException;

    public void validateClientId(OAuthJwtAccessToken var1, String var2) throws OAuthJwtAccessTokenException;

    public void validateCertificateBinding(OAuthJwtAccessToken var1, String var2) throws OAuthJwtAccessTokenException;

    default public void validateCertificateBinding(OAuthJwtAccessToken jwt, X509Certificate x509Certificate) throws OAuthJwtAccessTokenException {
        String certificateThumbprint;
        try {
            certificateThumbprint = this.getX509CertificateThumbprint(x509Certificate);
        }
        catch (CryptoException | CertificateEncodingException e) {
            throw new OAuthJwtAccessTokenException(e);
        }
        this.validateCertificateBinding(jwt, certificateThumbprint);
    }

    default public String getX509CertificateCommonName(X509Certificate x509Certificate) {
        return Crypto.extractX509CertCommonName(x509Certificate);
    }

    default public String getX509CertificateThumbprint(X509Certificate x509Certificate) throws CertificateEncodingException, CryptoException {
        byte[] encodedCert = Crypto.sha256(x509Certificate.getEncoded());
        return Base64.getUrlEncoder().withoutPadding().encodeToString(encodedCert);
    }
}

