/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.oauth.validator;

import com.yahoo.athenz.auth.oauth.token.OAuthJwtAccessToken;
import com.yahoo.athenz.auth.oauth.token.OAuthJwtAccessTokenException;
import com.yahoo.athenz.auth.oauth.validator.OAuthJwtAccessTokenValidator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultOAuthJwtAccessTokenValidator
implements OAuthJwtAccessTokenValidator {
    private String trustedIssuer = null;
    private Set<String> requiredAudiences = null;
    private Set<String> requiredScopes = null;
    private Map<String, Set<String>> authorizedClientIds = null;

    public DefaultOAuthJwtAccessTokenValidator(String trustedIssuer, Set<String> requiredAudiences, Set<String> requiredScopes, Map<String, Set<String>> authorizedClientIds) {
        if (trustedIssuer == null || trustedIssuer.isEmpty()) {
            throw new IllegalArgumentException("trusted issuers must be configured");
        }
        if (requiredAudiences == null || requiredAudiences.isEmpty()) {
            throw new IllegalArgumentException("required audiences must be configured");
        }
        if (requiredScopes == null || requiredScopes.isEmpty()) {
            throw new IllegalArgumentException("required scopes must be configured");
        }
        if (authorizedClientIds == null) {
            throw new IllegalArgumentException("client ID mapping must be configured");
        }
        this.trustedIssuer = trustedIssuer;
        this.requiredAudiences = requiredAudiences;
        this.requiredScopes = requiredScopes;
        this.authorizedClientIds = authorizedClientIds;
    }

    private void verifyIssuer(OAuthJwtAccessToken jwt) throws OAuthJwtAccessTokenException {
        String issuer = jwt.getIssuer();
        if (!this.trustedIssuer.equals(issuer)) {
            throw new OAuthJwtAccessTokenException("iss not trusted: got=" + issuer);
        }
    }

    private void verifyAudiences(OAuthJwtAccessToken jwt) throws OAuthJwtAccessTokenException {
        List<String> audiences = jwt.getAudiences();
        if (audiences == null || !new HashSet<String>(audiences).containsAll(this.requiredAudiences)) {
            String got = audiences == null ? "null" : String.join((CharSequence)", ", audiences);
            throw new OAuthJwtAccessTokenException("required aud not found: got=" + got);
        }
    }

    private void verifyScopes(OAuthJwtAccessToken jwt) throws OAuthJwtAccessTokenException {
        List<String> scopes = jwt.getScopes();
        if (scopes == null || !new HashSet<String>(scopes).containsAll(this.requiredScopes)) {
            throw new OAuthJwtAccessTokenException("required scope not found: got=" + jwt.getScope());
        }
    }

    private void verifyCertificateThumbprint(OAuthJwtAccessToken jwt, String certificateThumbprint) throws OAuthJwtAccessTokenException {
        String certThumbprint = jwt.getCertificateThumbprint();
        if (certificateThumbprint == certThumbprint) {
            return;
        }
        if (certificateThumbprint == null || certThumbprint == null || !certificateThumbprint.equals(certThumbprint)) {
            throw new OAuthJwtAccessTokenException(String.format("client certificate thumbprint (%s) not match: got=%s", certificateThumbprint, certThumbprint));
        }
    }

    private void verifyClientId(OAuthJwtAccessToken jwt, String certificatePrincipal) throws OAuthJwtAccessTokenException {
        String clientId = jwt.getClientId();
        Set<String> validClientIds = this.authorizedClientIds.get(certificatePrincipal);
        if (validClientIds == null) {
            throw new OAuthJwtAccessTokenException(String.format("NO mapping of authorized client IDs for certificate principal (%s)", certificatePrincipal));
        }
        if (!validClientIds.contains(clientId)) {
            throw new OAuthJwtAccessTokenException(String.format("client_id is not authorized for certificate principal (%s): got=%s", certificatePrincipal, clientId));
        }
    }

    @Override
    public void validate(OAuthJwtAccessToken jwt) throws OAuthJwtAccessTokenException {
        this.verifyIssuer(jwt);
        this.verifyAudiences(jwt);
        this.verifyScopes(jwt);
        if (jwt.getExpiration() <= 0L) {
            throw new OAuthJwtAccessTokenException("exp is empty");
        }
    }

    @Override
    public void validateClientId(OAuthJwtAccessToken jwt, String clientId) throws OAuthJwtAccessTokenException {
        this.verifyClientId(jwt, clientId);
    }

    @Override
    public void validateCertificateBinding(OAuthJwtAccessToken jwt, String certificateThumbprint) throws OAuthJwtAccessTokenException {
        this.verifyCertificateThumbprint(jwt, certificateThumbprint);
    }
}

