/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.oauth.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class OAuthAuthorityUtils {
    public static final String getProperty(String key, String def) {
        return System.getProperty("athenz.auth.oauth.jwt." + key, def);
    }

    public static final Set<String> csvToSet(String csv, String delimiter) {
        if (csv == null || csv.isEmpty()) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        if (delimiter == null || delimiter.isEmpty()) {
            set.add(csv);
        } else {
            Collections.addAll(set, csv.split(delimiter));
        }
        return set;
    }

    public static final String extractHeaderToken(HttpServletRequest request) {
        Enumeration headers = request.getHeaders("Authorization");
        while (headers.hasMoreElements()) {
            String value = (String)headers.nextElement();
            if (!value.toLowerCase().startsWith("bearer")) continue;
            String authHeaderValue = value.substring("bearer".length()).trim();
            int commaIndex = authHeaderValue.indexOf(44);
            if (commaIndex > 0) {
                authHeaderValue = authHeaderValue.substring(0, commaIndex);
            }
            return authHeaderValue;
        }
        return null;
    }

    private OAuthAuthorityUtils() {
    }
}

