/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.oauth.token;

import java.util.Arrays;
import java.util.List;

public interface OAuthJwtAccessToken {
    public static final String CLAIM_CONFIRM = "cnf";
    public static final String CLAIM_CONFIRM_X509_HASH = "x5t#S256";
    public static final String CLAIM_SCOPE = "scope";
    public static final String CLAIM_CLIENT_ID = "client_id";
    public static final String SCOPE_DELIMITER = " ";

    public String getSubject();

    public String getIssuer();

    public String getAudience();

    public List<String> getAudiences();

    public String getClientId();

    public String getCertificateThumbprint();

    public String getScope();

    default public List<String> getScopes() {
        if (this.getScope() == null) {
            return null;
        }
        return Arrays.asList(this.getScope().split(SCOPE_DELIMITER));
    }

    public long getIssuedAt();

    public long getExpiration();

    public String getSignature();

    public String toString();
}

