/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.oauth.token;

import com.yahoo.athenz.auth.oauth.token.OAuthJwtAccessToken;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.RequiredTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOAuthJwtAccessToken
implements OAuthJwtAccessToken {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOAuthJwtAccessToken.class);
    protected Claims body;
    protected String signature;

    public DefaultOAuthJwtAccessToken(Jws<Claims> jws) {
        this.body = (Claims)jws.getBody();
        this.signature = jws.getSignature();
    }

    @Override
    public String getSubject() {
        return this.body.getSubject();
    }

    @Override
    public String getIssuer() {
        return this.body.getIssuer();
    }

    @Override
    public String getAudience() {
        return this.body.getAudience();
    }

    @Override
    public List<String> getAudiences() {
        List<String> audiences;
        try {
            audiences = (List<String>)this.body.get("aud", ArrayList.class);
        }
        catch (RequiredTypeException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("DefaultOAuthJwtAccessToken:getAudiences treat audience as string, err: {}", (Object)e.getMessage());
            }
            audiences = Arrays.asList(this.body.getAudience());
        }
        return audiences;
    }

    @Override
    public String getClientId() {
        return (String)this.body.get("client_id", String.class);
    }

    @Override
    public String getCertificateThumbprint() {
        LinkedHashMap certConf = null;
        try {
            certConf = (LinkedHashMap)this.body.get("cnf", LinkedHashMap.class);
            if (certConf == null) {
                return null;
            }
        }
        catch (RequiredTypeException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("DefaultOAuthJwtAccessToken:getCertificateThumbprint expected data type to be JSON object, err: {}", (Object)e.getMessage());
            }
            return null;
        }
        return (String)certConf.get("x5t#S256");
    }

    @Override
    public String getScope() {
        return (String)this.body.get("scope", String.class);
    }

    @Override
    public long getIssuedAt() {
        Date date = this.body.getIssuedAt();
        if (date == null) {
            return 0L;
        }
        return this.body.getIssuedAt().getTime() / 1000L;
    }

    @Override
    public long getExpiration() {
        Date date = this.body.getExpiration();
        if (date == null) {
            return 0L;
        }
        return this.body.getExpiration().getTime() / 1000L;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public String toString() {
        return this.body.toString();
    }
}

