/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.oauth.parser;

import com.yahoo.athenz.auth.KeyStore;
import com.yahoo.athenz.auth.token.jwts.JwtsSigningKeyResolver;
import com.yahoo.athenz.auth.util.AthenzUtils;
import com.yahoo.athenz.auth.util.Crypto;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.SigningKeyResolver;
import java.security.Key;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreJwkKeyResolver
implements SigningKeyResolver {
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreJwkKeyResolver.class);
    private static final String SYS_AUTH_DOMAIN = "sys.auth";
    private KeyStore keyStore = null;
    private SigningKeyResolver jwksResolver = null;

    public KeyStoreJwkKeyResolver(KeyStore keyStore, String url, SSLContext sslContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("KeyStoreJwkKeyResolver:JWK URL: {}", (Object)url);
        }
        this.keyStore = keyStore;
        this.jwksResolver = new JwtsSigningKeyResolver(url, sslContext, true);
    }

    public Key resolveSigningKey(JwsHeader header, Claims claims) {
        String keyId = header.getKeyId();
        if (keyId == null || keyId.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("KeyStoreJwkKeyResolver:resolveSigningKey: invalid key ID: {}", (Object)keyId);
            }
            return null;
        }
        String issuer = claims.getIssuer();
        if (this.keyStore != null && issuer != null && !issuer.isEmpty()) {
            String[] ds = AthenzUtils.splitPrincipalName(issuer);
            if (ds == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("KeyStoreJwkKeyResolver:resolveSigningKey: skip using KeyStore, invalid issuer: {}", (Object)issuer);
                }
            } else {
                String domain = ds[0];
                String service = ds[1];
                if (!SYS_AUTH_DOMAIN.equals(domain)) {
                    LOG.debug("KeyStoreJwkKeyResolver:resolveSigningKey: skip using KeyStore, invalid domain: {}", (Object)domain);
                } else {
                    String publicKey = this.keyStore.getPublicKey(domain, service, keyId);
                    if (publicKey != null && !publicKey.isEmpty()) {
                        try {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("KeyStoreJwkKeyResolver:resolveSigningKey: will use public key from key store: ({}, {}, {})", new Object[]{domain, service, keyId});
                            }
                            return Crypto.loadPublicKey(publicKey);
                        }
                        catch (Exception ex) {
                            LOG.warn("KeyStoreJwkKeyResolver:resolveSigningKey: invalid public key format", (Throwable)ex);
                        }
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("KeyStoreJwkKeyResolver:resolveSigningKey: will use public key from JWKS: ({})", (Object)keyId);
        }
        return this.jwksResolver.resolveSigningKey(header, claims);
    }

    public Key resolveSigningKey(JwsHeader header, String plaintext) {
        return null;
    }
}

