/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.oauth.parser;

import com.yahoo.athenz.auth.KeyStore;
import com.yahoo.athenz.auth.oauth.parser.DefaultOAuthJwtAccessTokenParser;
import com.yahoo.athenz.auth.oauth.parser.OAuthJwtAccessTokenParser;
import com.yahoo.athenz.auth.oauth.parser.OAuthJwtAccessTokenParserFactory;
import java.util.function.BiFunction;

public class DefaultOAuthJwtAccessTokenParserFactory
implements OAuthJwtAccessTokenParserFactory {
    public static final String SYSTEM_PROP_PREFIX = "athenz.auth.oauth.jwt.parser.";
    public static final String JWKS_URL = "jwks_url";
    public static final BiFunction<String, String, String> GET_PROPERTY = (key, def) -> System.getProperty(SYSTEM_PROP_PREFIX + key, def);

    @Override
    public OAuthJwtAccessTokenParser create(KeyStore keyStore) throws IllegalArgumentException {
        String jwksUrl = GET_PROPERTY.apply(JWKS_URL, null);
        return new DefaultOAuthJwtAccessTokenParser(keyStore, jwksUrl);
    }
}

