/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.oauth.parser;

import com.yahoo.athenz.auth.KeyStore;
import com.yahoo.athenz.auth.oauth.parser.KeyStoreJwkKeyResolver;
import com.yahoo.athenz.auth.oauth.parser.OAuthJwtAccessTokenParser;
import com.yahoo.athenz.auth.oauth.token.DefaultOAuthJwtAccessToken;
import com.yahoo.athenz.auth.oauth.token.OAuthJwtAccessToken;
import com.yahoo.athenz.auth.oauth.token.OAuthJwtAccessTokenException;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolver;

public class DefaultOAuthJwtAccessTokenParser
implements OAuthJwtAccessTokenParser {
    public static final int ALLOWED_CLOCK_SKEW_SECONDS = 60;
    protected JwtParser parser = null;

    public DefaultOAuthJwtAccessTokenParser(KeyStore keyStore, String jwksUrl) throws IllegalArgumentException {
        if (keyStore == null) {
            throw new IllegalArgumentException("DefaultOAuthJwtAccessTokenParser: keyStore is null");
        }
        KeyStoreJwkKeyResolver signingKeyResolver = new KeyStoreJwkKeyResolver(keyStore, jwksUrl, null);
        this.parser = Jwts.parserBuilder().setSigningKeyResolver((SigningKeyResolver)signingKeyResolver).setAllowedClockSkewSeconds(60L).build();
    }

    @Override
    public OAuthJwtAccessToken parse(String jwtString) throws OAuthJwtAccessTokenException {
        DefaultOAuthJwtAccessToken accessToken = null;
        try {
            Jws jws = this.parser.parseClaimsJws(jwtString);
            accessToken = new DefaultOAuthJwtAccessToken((Jws<Claims>)jws);
        }
        catch (Exception ex) {
            throw new OAuthJwtAccessTokenException(ex);
        }
        return accessToken;
    }
}

