/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.oauth;

import com.yahoo.athenz.auth.Authority;
import com.yahoo.athenz.auth.AuthorityKeyStore;
import com.yahoo.athenz.auth.KeyStore;
import com.yahoo.athenz.auth.Principal;
import com.yahoo.athenz.auth.impl.CertificateIdentity;
import com.yahoo.athenz.auth.impl.CertificateIdentityException;
import com.yahoo.athenz.auth.impl.CertificateIdentityParser;
import com.yahoo.athenz.auth.impl.SimplePrincipal;
import com.yahoo.athenz.auth.oauth.parser.OAuthJwtAccessTokenParser;
import com.yahoo.athenz.auth.oauth.parser.OAuthJwtAccessTokenParserFactory;
import com.yahoo.athenz.auth.oauth.token.OAuthJwtAccessToken;
import com.yahoo.athenz.auth.oauth.token.OAuthJwtAccessTokenException;
import com.yahoo.athenz.auth.oauth.util.OAuthAuthorityUtils;
import com.yahoo.athenz.auth.oauth.validator.DefaultOAuthJwtAccessTokenValidator;
import com.yahoo.athenz.auth.oauth.validator.OAuthJwtAccessTokenValidator;
import com.yahoo.athenz.auth.util.AthenzUtils;
import com.yahoo.athenz.auth.util.CryptoException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthCertBoundJwtAccessTokenAuthority
implements Authority,
AuthorityKeyStore,
KeyStore {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthCertBoundJwtAccessTokenAuthority.class);
    private String authenticateChallenge = "Bearer realm=\"athenz.io\"";
    private KeyStore keyStore = null;
    private CertificateIdentityParser certificateIdentityParser = null;
    private OAuthJwtAccessTokenParser parser = null;
    private OAuthJwtAccessTokenValidator validator = null;
    Map<String, String> authorizedServices = null;
    private boolean shouldVerifyCertThumbprint = true;

    @Override
    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    public String getPublicKey(String domain, String service, String keyId) {
        return this.keyStore.getPublicKey(domain, service, keyId);
    }

    @Override
    public Authority.CredSource getCredSource() {
        return Authority.CredSource.REQUEST;
    }

    @Override
    public String getAuthenticateChallenge() {
        return this.authenticateChallenge;
    }

    @Override
    public String getDomain() {
        return null;
    }

    @Override
    public String getHeader() {
        return "Authorization";
    }

    @Override
    public Principal authenticate(String credentials, String remoteAddr, String httpMethod, StringBuilder errMsg) {
        return null;
    }

    private void reportError(String message, StringBuilder errMsg) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(message);
        }
        if (errMsg != null) {
            errMsg.append(message);
        }
    }

    private void processAuthorizedClientIds(String authorizedClientIdsPath, Map<String, Set<String>> authorizedClientIds, Map<String, String> authorizedServices) {
        if (authorizedClientIdsPath == null || authorizedClientIdsPath.isEmpty()) {
            return;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(authorizedClientIdsPath));){
            String line = br.readLine();
            while (line != null) {
                if (!line.isEmpty()) {
                    String mapEntry = line.trim();
                    boolean isInvalid = false;
                    String[] comps = mapEntry.split(":");
                    if (comps.length != 3) {
                        LOG.error("Skipping invalid client id entry {}", (Object)mapEntry);
                        isInvalid = true;
                    }
                    for (String comp : comps) {
                        if (!comp.isEmpty()) continue;
                        LOG.error("Skipping invalid client id entry {}", (Object)mapEntry);
                        isInvalid = true;
                        break;
                    }
                    if (!isInvalid) {
                        Set<String> clientIds = OAuthAuthorityUtils.csvToSet(comps[0], ",");
                        if (clientIds == null || clientIds.contains("")) {
                            LOG.error("Skipping invalid client id entry {}", (Object)mapEntry);
                        } else {
                            authorizedClientIds.put(comps[1], clientIds);
                            authorizedServices.put(comps[1], comps[2]);
                        }
                    }
                }
                line = br.readLine();
            }
        }
        catch (Exception e) {
            LOG.error("Unable to process client id list: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void initialize() {
        String authnChallengeRealm = OAuthAuthorityUtils.getProperty("authn_challenge_realm", "https://athenz.io");
        this.authenticateChallenge = String.format("Bearer realm=\"%s\"", authnChallengeRealm);
        boolean excludeRoleCertificates = Boolean.valueOf(OAuthAuthorityUtils.getProperty("cert.exclude_role_certificates", "false"));
        Set<String> excludedPrincipals = OAuthAuthorityUtils.csvToSet(OAuthAuthorityUtils.getProperty("cert.excluded_principals", ""), ",");
        this.certificateIdentityParser = new CertificateIdentityParser(excludedPrincipals, excludeRoleCertificates);
        String jwtParserFactoryClass = OAuthAuthorityUtils.getProperty("parser_factory_class", "com.yahoo.athenz.auth.oauth.parser.DefaultOAuthJwtAccessTokenParserFactory");
        try {
            OAuthJwtAccessTokenParserFactory jwtParserFactory = (OAuthJwtAccessTokenParserFactory)Class.forName(jwtParserFactoryClass).newInstance();
            this.parser = jwtParserFactory.create(this);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.error("Invalid OAuthJwtAccessTokenParserFactory class: {} error: {}", (Object)jwtParserFactoryClass, (Object)e.getMessage());
            throw new IllegalArgumentException("Invalid JWT parser class", e);
        }
        this.shouldVerifyCertThumbprint = Boolean.valueOf(OAuthAuthorityUtils.getProperty("verify_cert_thumbprint", "true"));
        String authorizedClientIdsPath = OAuthAuthorityUtils.getProperty("authorized_client_ids_path", "");
        HashMap<String, Set<String>> authorizedClientIds = new HashMap<String, Set<String>>();
        HashMap<String, String> authorizedServices = new HashMap<String, String>();
        this.processAuthorizedClientIds(authorizedClientIdsPath, authorizedClientIds, authorizedServices);
        this.authorizedServices = authorizedServices;
        String trustedIssuer = OAuthAuthorityUtils.getProperty("claim.iss", "https://athenz.io");
        Set<String> requiredAudiences = OAuthAuthorityUtils.csvToSet(OAuthAuthorityUtils.getProperty("claim.aud", "https://zms.athenz.io"), ",");
        Set<String> requiredScopes = OAuthAuthorityUtils.csvToSet(OAuthAuthorityUtils.getProperty("claim.scope", "sys.auth:role.admin"), " ");
        this.validator = new DefaultOAuthJwtAccessTokenValidator(trustedIssuer, requiredAudiences, requiredScopes, authorizedClientIds);
    }

    @Override
    public Principal authenticate(HttpServletRequest request, StringBuilder errMsg) {
        errMsg = errMsg == null ? new StringBuilder(512) : errMsg;
        String jwsString = OAuthAuthorityUtils.extractHeaderToken(request);
        if (jwsString == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("OAuthCertBoundJwtAccessTokenAuthority:authenticate: no credentials, skip...");
            }
            return null;
        }
        CertificateIdentity certificateIdentity = null;
        try {
            certificateIdentity = this.certificateIdentityParser.parse(request);
        }
        catch (CertificateIdentityException e) {
            this.reportError("OAuthCertBoundJwtAccessTokenAuthority:authenticate: invalid certificate: " + e.getMessage(), errMsg);
            return null;
        }
        X509Certificate clientCert = certificateIdentity.getX509Certificate();
        String clientCertPrincipal = certificateIdentity.getPrincipalName();
        OAuthJwtAccessToken at = null;
        try {
            at = this.parser.parse(jwsString);
        }
        catch (OAuthJwtAccessTokenException e) {
            this.reportError("OAuthCertBoundJwtAccessTokenAuthority:authenticate: invalid JWT: " + e.getMessage(), errMsg);
            return null;
        }
        try {
            this.validator.validate(at);
            this.validator.validateClientId(at, clientCertPrincipal);
            if (this.shouldVerifyCertThumbprint) {
                String clientCertThumbprint = this.validator.getX509CertificateThumbprint(clientCert);
                this.validator.validateCertificateBinding(at, clientCertThumbprint);
            }
        }
        catch (OAuthJwtAccessTokenException | CryptoException | CertificateEncodingException e) {
            this.reportError("OAuthCertBoundJwtAccessTokenAuthority:authenticate: invalid JWT: " + e.getMessage(), errMsg);
            return null;
        }
        String[] ds = AthenzUtils.splitPrincipalName(at.getSubject());
        if (ds == null) {
            errMsg.append("OAuthCertBoundJwtAccessTokenAuthority:authenticate: sub is not a valid service identity: got=").append(at.getSubject());
            return null;
        }
        String domain = ds[0];
        String service = ds[1];
        SimplePrincipal principal = (SimplePrincipal)SimplePrincipal.create(domain, service, jwsString, at.getIssuedAt(), this);
        principal.setUnsignedCreds(at.toString());
        principal.setX509Certificate(clientCert);
        principal.setApplicationId(clientCertPrincipal);
        principal.setAuthorizedService(this.authorizedServices.getOrDefault(clientCertPrincipal, clientCertPrincipal));
        if (LOG.isDebugEnabled()) {
            LOG.debug("OAuthCertBoundJwtAccessTokenAuthority.authenticate: client certificate name={}", (Object)clientCertPrincipal);
            LOG.debug("OAuthCertBoundJwtAccessTokenAuthority.authenticate: valid user={}", (Object)principal.toString());
            LOG.debug("OAuthCertBoundJwtAccessTokenAuthority.authenticate: unsignedCredentials={}", (Object)principal.getUnsignedCredentials());
            LOG.debug("OAuthCertBoundJwtAccessTokenAuthority.authenticate: credentials={}", (Object)principal.getCredentials());
        }
        return principal;
    }
}

