/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.impl;

import com.yahoo.athenz.auth.Authority;
import com.yahoo.athenz.auth.Principal;
import com.yahoo.athenz.auth.impl.SimplePrincipal;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.util.encoders.Base64;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.UnixUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAuthority
implements Authority {
    private static final Logger LOG = LoggerFactory.getLogger(UserAuthority.class);
    static final String ATHENZ_PROP_PAM_SERVICE_NAME = "athenz.auth.user.pam_service_name";
    public static final String ATHENZ_AUTH_CHALLENGE = "Basic realm=\"athenz\"";
    String serviceName = System.getProperty("athenz.auth.user.pam_service_name", "login");
    private PAM pam = null;

    @Override
    public void initialize() {
    }

    @Override
    public String getID() {
        return "Auth-UNIX";
    }

    @Override
    public String getDomain() {
        return "user";
    }

    @Override
    public String getHeader() {
        return "Authorization";
    }

    @Override
    public String getAuthenticateChallenge() {
        return ATHENZ_AUTH_CHALLENGE;
    }

    @Override
    public boolean allowAuthorization() {
        return false;
    }

    void setPAM(PAM pam) {
        this.pam = pam;
    }

    PAM getPAM() throws PAMException {
        if (this.pam != null) {
            return this.pam;
        }
        return new PAM(this.serviceName);
    }

    @Override
    public Principal authenticate(String creds, String remoteAddr, String httpMethod, StringBuilder errMsg) {
        UnixUser user;
        String decodedCreds;
        StringBuilder stringBuilder = errMsg = errMsg == null ? new StringBuilder(512) : errMsg;
        if (!creds.startsWith("Basic ")) {
            errMsg.append("UserAuthority:authenticate: credentials do not start with 'Basic '");
            LOG.error(errMsg.toString());
            return null;
        }
        String encodedPassword = creds.substring(6);
        if (encodedPassword.isEmpty()) {
            errMsg.append("UserAuthority:authenticate: no credentials after 'Basic '");
            LOG.error(errMsg.toString());
            return null;
        }
        try {
            decodedCreds = new String(Base64.decode((byte[])encodedPassword.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            errMsg.append("UserAuthority:authenticate: factory exc=").append(e.getMessage());
            LOG.error(errMsg.toString());
            return null;
        }
        int idx = decodedCreds.indexOf(58);
        if (idx == -1) {
            errMsg.append("LDAPAuthority: authenticate: no password specified");
            LOG.error(errMsg.toString());
            return null;
        }
        String username = decodedCreds.substring(0, idx);
        String password = decodedCreds.substring(idx + 1);
        try {
            user = this.getPAM().authenticate(username, password);
        }
        catch (Throwable ex) {
            errMsg.append("UserAuthority:authenticate: failed: user=").append(username).append(" exc=").append(ex.getMessage());
            LOG.error(errMsg.toString());
            return null;
        }
        if (user == null) {
            errMsg.append("UserAuthority:authenticate: failed: user=").append(username);
            LOG.error(errMsg.toString());
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("UserAuthority.authenticate: valid user={}", (Object)username);
        }
        long issueTime = 0L;
        SimplePrincipal princ = this.getSimplePrincipal(username.toLowerCase(), creds, issueTime);
        if (princ == null) {
            errMsg.append("UserAuthority:authenticate: failed to create principal: user=").append(username);
            LOG.error(errMsg.toString());
            return null;
        }
        princ.setUnsignedCreds(username);
        return princ;
    }

    SimplePrincipal getSimplePrincipal(String name, String creds, long issueTime) {
        return (SimplePrincipal)SimplePrincipal.create(this.getDomain(), name, creds, issueTime, this);
    }
}

