/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.impl;

import com.yahoo.athenz.auth.Authority;
import com.yahoo.athenz.auth.Principal;
import com.yahoo.athenz.auth.impl.SimplePrincipal;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUserAuthority
implements Authority {
    private static final Logger LOG = LoggerFactory.getLogger(TestUserAuthority.class);
    public static final String ATHENZ_AUTH_CHALLENGE = "Basic realm=\"athenz\"";

    @Override
    public void initialize() {
    }

    @Override
    public String getID() {
        return "Auth-TESTUSER";
    }

    @Override
    public String getDomain() {
        return "user";
    }

    @Override
    public String getHeader() {
        return "Authorization";
    }

    @Override
    public String getAuthenticateChallenge() {
        return ATHENZ_AUTH_CHALLENGE;
    }

    @Override
    public boolean allowAuthorization() {
        return false;
    }

    @Override
    public Principal authenticate(String creds, String remoteAddr, String httpMethod, StringBuilder errMsg) {
        String password;
        String decodedCreds;
        StringBuilder stringBuilder = errMsg = errMsg == null ? new StringBuilder(512) : errMsg;
        if (!creds.startsWith("Basic ")) {
            errMsg.append("UserAuthority:authenticate: credentials do not start with 'Basic '");
            LOG.error(errMsg.toString());
            return null;
        }
        String encodedPassword = creds.substring(6);
        if (encodedPassword.isEmpty()) {
            errMsg.append("TestUserAuthority:authenticate: no credentials after 'Basic '");
            LOG.error(errMsg.toString());
            return null;
        }
        try {
            decodedCreds = new String(Base64.decode((byte[])encodedPassword.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            errMsg.append("UserAuthority:authenticate: factory exc=").append(e.getMessage());
            LOG.error(errMsg.toString());
            return null;
        }
        int idx = decodedCreds.indexOf(58);
        if (idx == -1) {
            errMsg.append("TestUserAuthority: authenticate: no password specified");
            LOG.error(errMsg.toString());
            return null;
        }
        String username = decodedCreds.substring(0, idx);
        if (!username.equals(password = decodedCreds.substring(idx + 1))) {
            LOG.error("TestUserAuthority:authenticate: failed: username and password do not match");
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("TestUserAuthority.authenticate: valid user={}", (Object)username);
        }
        long issueTime = 0L;
        SimplePrincipal princ = this.getSimplePrincipal(username.toLowerCase(), creds, issueTime);
        if (princ == null) {
            errMsg.append("TestUserAuthority:authenticate: failed to create principal: user=").append(username);
            LOG.error(errMsg.toString());
            return null;
        }
        princ.setUnsignedCreds(username);
        return princ;
    }

    SimplePrincipal getSimplePrincipal(String name, String creds, long issueTime) {
        return (SimplePrincipal)SimplePrincipal.create(this.getDomain(), name, creds, issueTime, this);
    }
}

