/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.impl;

import com.yahoo.athenz.auth.Authority;
import com.yahoo.athenz.auth.Principal;
import com.yahoo.athenz.auth.ServiceIdentityProvider;
import com.yahoo.athenz.auth.impl.PrincipalAuthority;
import com.yahoo.athenz.auth.impl.SimplePrincipal;
import com.yahoo.athenz.auth.token.PrincipalToken;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivateKey;

public class SimpleServiceIdentityProvider
implements ServiceIdentityProvider {
    private static final Authority PRINCIPAL_AUTHORITY = new PrincipalAuthority();
    private String domain;
    private String service;
    private PrivateKey key;
    private long tokenTimeout;
    private String keyId;
    private String host = null;
    private Authority authority;

    public SimpleServiceIdentityProvider(String domainName, String serviceName, PrivateKey privateKey, String keyId) {
        this(PRINCIPAL_AUTHORITY, domainName, serviceName, privateKey, keyId, 3600L);
    }

    public SimpleServiceIdentityProvider(String domainName, String serviceName, PrivateKey privateKey, String keyId, long tokenTimeout) {
        this(PRINCIPAL_AUTHORITY, domainName, serviceName, privateKey, keyId, tokenTimeout);
    }

    public SimpleServiceIdentityProvider(Authority authority, String domainName, String serviceName, PrivateKey privateKey, String keyId, long tokenTimeout) {
        this.authority = authority;
        this.domain = domainName.toLowerCase();
        this.service = serviceName.toLowerCase();
        this.key = privateKey;
        this.keyId = keyId.toLowerCase();
        this.tokenTimeout = tokenTimeout;
        this.setHost(this.getServerHostName());
    }

    @Override
    public Principal getIdentity(String domainName, String serviceName) {
        domainName = domainName.toLowerCase();
        serviceName = serviceName.toLowerCase();
        if (!domainName.equals(this.domain) || !serviceName.equals(this.service)) {
            return null;
        }
        PrincipalToken token = new PrincipalToken.Builder("S1", domainName, serviceName).expirationWindow(this.tokenTimeout).host(this.host).keyId(this.keyId).build();
        token.sign(this.key);
        SimplePrincipal principal = (SimplePrincipal)SimplePrincipal.create(domainName, serviceName, token.getSignedToken(), System.currentTimeMillis() / 1000L, this.authority);
        principal.setUnsignedCreds(token.getUnsignedToken());
        return principal;
    }

    String getServerHostName() {
        String urlhost;
        try {
            InetAddress localhost = this.getLocalHost();
            urlhost = localhost.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            urlhost = "localhost";
        }
        return urlhost;
    }

    InetAddress getLocalHost() throws UnknownHostException {
        return InetAddress.getLocalHost();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setTokenTimeout(long tokenTimeout) {
        this.tokenTimeout = tokenTimeout;
    }

    public Authority getAuthority() {
        return this.authority;
    }

    public void setAuthority(Authority authority) {
        this.authority = authority;
    }
}

